/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.lang.reflect.Field;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.Log4JUtils;
import org.echocat.jomon.runtime.ManifestInformationFactory;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.io.UrlUtils;
import org.echocat.jomon.spring.ContextLoadThreadGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Boot {
    private static final Logger LOG;
    private static ManifestInformationFactory c_informationFactory;

    public static void main(String[] args) {
        if (args == null || args.length != 1 && args.length != 2) {
            System.err.println("java -cp <?> " + Boot.class.getName() + " <boot bean.xml in classpath> [log4j configuration in classpath]");
            System.exit(1);
        } else {
            Boot.start(args[0], args.length == 2 ? args[1] : null);
        }
    }

    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName) {
        return Boot.start(reference, bootBeanXmlFileName, null);
    }

    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull Class<?> reference, @Nonnull String bootBeanXmlFileName, @Nullable String log4jConfigurationFileName) {
        String bootBeanXmlInClassPath = Boot.fullElementPath(reference, bootBeanXmlFileName);
        String log4jConfigurationInClassPath = log4jConfigurationFileName != null ? Boot.fullElementPath(reference, log4jConfigurationFileName) : null;
        return Boot.start(bootBeanXmlInClassPath, log4jConfigurationInClassPath);
    }

    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath) {
        return Boot.start(bootBeanXmlInClassPath, null);
    }

    @Nonnull
    public static ConfigurableApplicationContext start(@Nonnull String bootBeanXmlInClassPath, @Nullable String log4jConfigurationInClassPath) {
        Boot.configureInformationFactory(bootBeanXmlInClassPath);
        Boot.configureLog4j(log4jConfigurationInClassPath);
        return Boot.startComponent(bootBeanXmlInClassPath, Boot.getApplicationName());
    }

    @Nonnull
    public static ConfigurableApplicationContext startComponent(@Nonnull String bootBeanXmlInClassPath, @Nonnull String applicationName) {
        return Boot.startComponent(null, bootBeanXmlInClassPath, applicationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ConfigurableApplicationContext startComponent(@Nullable ApplicationContext parent, @Nonnull String bootBeanXmlInClassPath, final @Nonnull String applicationName) {
        StopWatch stopWatch = new StopWatch();
        LOG.info("Starting " + applicationName + "...");
        final ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{bootBeanXmlInClassPath}, false, parent);
        Thread shutdownHook = new Thread("destroyer"){

            @Override
            public void run() {
                LOG.info("Stopping " + applicationName + "...");
                applicationContext.close();
                LOG.info("Stopping " + applicationName + "... DONE!");
            }
        };
        boolean success = false;
        boolean applicationContextStarted = false;
        try {
            applicationContext.refresh();
            applicationContextStarted = true;
            Boot.waitForContextLoadThreads((AbstractApplicationContext)applicationContext);
            Boot.setShutdownHook(shutdownHook, (AbstractApplicationContext)applicationContext);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            LOG.info("Starting " + applicationName + "... DONE! (after: " + stopWatch + ")");
            success = true;
        }
        finally {
            if (applicationContextStarted && !success) {
                applicationContext.close();
            }
        }
        return applicationContext;
    }

    @Nonnull
    public static String fullElementPath(@Nonnull Class<?> reference, @Nonnull String element) {
        return reference.getPackage().getName().replace('.', '/') + '/' + element;
    }

    @Nonnull
    public static ManifestInformationFactory getInformationFactory() {
        return c_informationFactory;
    }

    @Nonnull
    public static String getApplicationName() {
        String applicationInfoString = c_informationFactory.getApplicationInfoString();
        return applicationInfoString != null ? applicationInfoString : Boot.class.getName();
    }

    private static void configureInformationFactory(String bootBeanXmlInClassPath) {
        c_informationFactory = new ManifestInformationFactory(bootBeanXmlInClassPath, Boot.class.getClassLoader());
    }

    public static void configureLog4j(@Nullable String log4jConfigurationInClassPath) {
        Log4JUtils.configureRuntime((URL)(log4jConfigurationInClassPath != null ? Boot.class.getClassLoader().getResource(log4jConfigurationInClassPath) : Boot.class.getResource("default.log4j.xml")));
    }

    protected static void waitForContextLoadThreads(@Nonnull AbstractApplicationContext applicationContext) {
        try {
            for (ContextLoadThreadGroup contextLoadThreadGroup : applicationContext.getBeansOfType(ContextLoadThreadGroup.class).values()) {
                contextLoadThreadGroup.join();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected static void setShutdownHook(@Nonnull Thread thread, @Nonnull AbstractApplicationContext to) {
        try {
            Field field = AbstractApplicationContext.class.getDeclaredField("shutdownHook");
            field.setAccessible(true);
            field.set(to, thread);
        }
        catch (Exception e) {
            LOG.warn("Could not register shutdownHook at " + to + " this could cause to much memory consume of the JVM.", (Throwable)e);
        }
    }

    private Boot() {
    }

    static {
        UrlUtils.registerUrlStreamHandlerIfNeeded();
        LOG = LoggerFactory.getLogger(Boot.class);
        c_informationFactory = new ManifestInformationFactory(Boot.class);
    }
}

