/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.util.Duration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ContextLoadThreadGroup
implements ApplicationContextAware,
Iterable<Thread>,
Thread.UncaughtExceptionHandler {
    private final Map<Thread, List<Throwable>> _failedThreads = Collections.synchronizedMap(new HashMap());
    private final Set<Thread> _threads = Collections.synchronizedSet(new HashSet());
    private String _name;

    public void addAndStart(@Nonnull Thread thread) {
        thread.setUncaughtExceptionHandler(this);
        this._threads.add(thread);
        thread.start();
    }

    public void join() throws InterruptedException {
        for (Thread thread : this) {
            if (!thread.isAlive()) continue;
            thread.join();
        }
        this.throwRuntimeExceptionOn();
    }

    public boolean join(@Nonnull Duration duration) throws InterruptedException {
        boolean result = true;
        Iterator<Thread> i = this.iterator();
        StopWatch stopWatch = new StopWatch();
        while (result && i.hasNext()) {
            Thread thread = i.next();
            if (thread.isAlive()) {
                thread.join(duration.minus(stopWatch.getCurrentDuration()).toMilliSeconds());
            }
            result = !thread.isAlive();
        }
        if (result) {
            this.throwRuntimeExceptionOn();
        }
        return result;
    }

    public void throwExceptionOn() throws Exception {
        this.throwOn(Exception.class);
    }

    public void throwRuntimeExceptionOn() throws RuntimeException {
        this.throwOn(RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Throwable> void throwOn(@Nonnull Class<T> allowedThrowableType) throws T {
        Map<Thread, List<Throwable>> map = this._failedThreads;
        synchronized (map) {
            Throwable highestRatedThrowable = this.findHighestRatedThrowableIn(this._failedThreads);
            if (highestRatedThrowable != null) {
                for (List<Throwable> throwables : this._failedThreads.values()) {
                    for (Throwable throwable : throwables) {
                        if (highestRatedThrowable.equals(throwable)) continue;
                        highestRatedThrowable.addSuppressed(throwable);
                    }
                }
                if (allowedThrowableType.isInstance(highestRatedThrowable)) {
                    throw (Throwable)allowedThrowableType.cast(highestRatedThrowable);
                }
                if (highestRatedThrowable instanceof RuntimeException) {
                    throw (RuntimeException)highestRatedThrowable;
                }
                if (highestRatedThrowable instanceof Error) {
                    throw (Error)highestRatedThrowable;
                }
                throw new RuntimeException(highestRatedThrowable);
            }
        }
    }

    @Nullable
    protected Throwable findHighestRatedThrowableIn(@Nonnull Map<Thread, List<Throwable>> threadToExceptions) {
        Throwable result = null;
        for (List<Throwable> exceptions : threadToExceptions.values()) {
            Throwable current = this.findHighestRatedThrowableIn(exceptions);
            if (!this.isHigherRated(current, result)) continue;
            result = current;
        }
        return result;
    }

    @Nullable
    protected Throwable findHighestRatedThrowableIn(@Nonnull Iterable<Throwable> exceptions) {
        Throwable result = null;
        for (Throwable exception : exceptions) {
            if (!this.isHigherRated(exception, result)) continue;
            result = exception;
        }
        return result;
    }

    protected boolean isHigherRated(@Nonnull Throwable what, @Nullable Throwable inRelationTo) {
        boolean result = inRelationTo instanceof Error ? false : (inRelationTo instanceof Throwable && !(inRelationTo instanceof Exception) ? what instanceof Error : (inRelationTo != null ? what instanceof Error || what instanceof Throwable && !(what instanceof Exception) : true));
        return result;
    }

    public boolean isAtLeastOneThreadAlive() {
        boolean result = false;
        Iterator<Thread> i = this.iterator();
        while (!result && i.hasNext()) {
            result = i.next().isAlive();
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this._name == null) {
            this._name = applicationContext.getDisplayName();
        }
    }

    @Override
    public Iterator<Thread> iterator() {
        return this.getThreads().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Set<Thread> getThreads() {
        Set<Thread> threads;
        Set<Thread> set = this._threads;
        synchronized (set) {
            threads = Collections.unmodifiableSet(new HashSet<Thread>(this._threads));
        }
        return threads;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Nonnull
    protected String getNameInternal() {
        String name = this._name;
        return name != null ? name : "ContextLoadThreadGroup";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Map<Thread, List<Throwable>> map = this._failedThreads;
        synchronized (map) {
            List<Throwable> throwables = this._failedThreads.get(t);
            if (throwables == null) {
                throwables = new ArrayList<Throwable>();
                this._failedThreads.put(t, throwables);
            }
            throwables.add(e);
        }
    }

    public String toString() {
        return this.getNameInternal();
    }
}

