/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.testing.BaseMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class Assert {
    protected Assert() {
    }

    public static void assertThat(boolean actual) {
        Assert.assertThat(null, actual);
    }

    public static void assertThat(@Nullable String reason, boolean actual) {
        Assert.assertThat(reason, actual, BaseMatchers.is(true));
    }

    public static <T> void assertThat(@Nullable T actual, @Nonnull Matcher<T> matcher) {
        Assert.assertThat(null, actual, matcher);
    }

    public static <T> void assertThat(@Nullable String reason, @Nullable T actual, @Nonnull Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            if (reason != null) {
                description.appendText(reason);
            }
            description.appendText("\nExpected: ");
            description.appendDescriptionOf(matcher);
            description.appendText("\n     but: ");
            matcher.describeMismatch(actual, (Description)description);
            description.appendText("\n");
            Assert.fail(description.toString());
        }
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void fail(@Nullable String message) {
        AssertionError error = message != null ? new AssertionError((Object)message) : new AssertionError();
        ((Throwable)((Object)error)).setStackTrace(Assert.getCleanStackTrace());
        throw error;
    }

    @Nonnull
    protected static StackTraceElement[] getCleanStackTrace() {
        StackTraceElement element;
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
        stackTrace.remove(0);
        Iterator i = stackTrace.iterator();
        while (i.hasNext() && (element = (StackTraceElement)i.next()).getClassName().equals(Assert.class.getName())) {
            i.remove();
        }
        return stackTrace.toArray(new StackTraceElement[stackTrace.size()]);
    }
}

