/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CollectionMatchers {
    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> isEqualTo(T ... expectedItems) {
        return CollectionMatchers.isEqualTo(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> isEqualTo(final @Nonnull Iterable<T> expectedItems) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public boolean matchesSafely(Iterable<T> items) {
                boolean result;
                if (items != null) {
                    result = true;
                    Iterator expectedItemsIterator = expectedItems.iterator();
                    Iterator itemsIterator = items.iterator();
                    while (expectedItemsIterator.hasNext() && itemsIterator.hasNext() && result) {
                        Object expectedItem = expectedItemsIterator.next();
                        Object item = itemsIterator.next();
                        result = expectedItem != null ? expectedItem.equals(item) : item == null;
                    }
                    if (result) {
                        result = !expectedItemsIterator.hasNext() && !itemsIterator.hasNext();
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is equal to ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Collection<T>> containsAllItemsOf(T ... expectedItems) {
        return CollectionMatchers.containsAllItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Collection<T>> containsAllItemsOf(final @Nonnull Collection<T> expectedItems) {
        return new TypeSafeMatcher<Collection<T>>(){

            public boolean matchesSafely(Collection<T> items) {
                boolean result;
                if (items != null) {
                    if (expectedItems.size() == items.size()) {
                        Iterator i = expectedItems.iterator();
                        result = true;
                        while (i.hasNext() & result) {
                            Object expectedItem = i.next();
                            result = items.contains(expectedItem);
                        }
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains all items ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Collection<T>> containsItemsOf(T ... expectedItems) {
        return CollectionMatchers.containsItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Collection<T>> containsItemsOf(final @Nonnull Collection<T> expectedItems) {
        return new TypeSafeMatcher<Collection<T>>(){

            public boolean matchesSafely(Collection<T> items) {
                boolean result;
                if (items != null) {
                    Iterator i = expectedItems.iterator();
                    result = true;
                    while (i.hasNext() & result) {
                        Object expectedItem = i.next();
                        result = items.contains(expectedItem);
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains items ").appendValue((Object)expectedItems);
            }
        };
    }

    @Nonnull
    public static Matcher<Collection<?>> hasSize(final @Nonnegative int size) {
        return new TypeSafeMatcher<Collection<?>>(){

            public boolean matchesSafely(@Nullable Collection<?> item) {
                return size == 0 ? item == null || item.isEmpty() : item != null && size == item.size();
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)size);
            }

            protected void describeMismatchSafely(@Nullable Collection<?> actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.size() : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }
        };
    }

    @Nonnull
    public static Matcher<Collection<?>> hasSameSizeAs(final @Nullable Object what) {
        return new TypeSafeMatcher<Collection<?>>(){

            public boolean matchesSafely(@Nullable Collection<?> item) {
                return this.getSizeOf(what) == 0 ? item == null || item.isEmpty() : item != null && this.getSizeOf(what) == item.size();
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)(what != null ? this.getSizeOf(what) : 0)).appendText(" (Same as: ").appendValue(what).appendText(")");
            }

            protected void describeMismatchSafely(@Nullable Collection<?> actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.size() : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }

            private int getSizeOf(@Nullable Object what2) {
                int result;
                if (what2 == null) {
                    result = 0;
                } else if (what2 instanceof Collection) {
                    result = ((Collection)what2).size();
                } else if (what2 instanceof Map) {
                    result = ((Map)what2).size();
                } else if (what2 instanceof Object[]) {
                    result = ((Object[])what2).length;
                } else if (what2 instanceof CharSequence) {
                    result = ((CharSequence)what2).length();
                } else {
                    throw new IllegalArgumentException("Could not get size of " + what2 + ".");
                }
                return result;
            }
        };
    }

    private CollectionMatchers() {
    }
}

