/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JUtils {
    protected static void tryInstallJulToSlf4jBridge() {
        try {
            ClassLoader classLoader = Log4JUtils.class.getClassLoader();
            Handler handler = (Handler)classLoader.loadClass("org.slf4j.bridge.SLF4JBridgeHandler").newInstance();
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            Logger logger = logManager.getLogger("");
            for (Handler oldHandlers : logger.getHandlers()) {
                logger.removeHandler(oldHandlers);
            }
            logger.addHandler(handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void tryFixMdcInSlf4j() {
        try {
            ClassLoader classLoader = Log4JUtils.class.getClassLoader();
            Class<?> mdc = classLoader.loadClass("org.slf4j.MDC");
            Class<?> mdcAdapter = classLoader.loadClass("org.slf4j.spi.MDCAdapter");
            Field mdcAdapterField = mdc.getDeclaredField("mdcAdapter");
            if (mdcAdapterField.getType().equals(mdcAdapter)) {
                mdcAdapterField.setAccessible(true);
                Object delegate = mdcAdapterField.get(null);
                Object fixed = classLoader.loadClass("org.echocat.jomon.runtime.FixingSlf4jMDCAdapter").getConstructor(mdcAdapter).newInstance(delegate);
                mdcAdapterField.set(null, fixed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void configureRuntime(@Nullable URL defaultXmlConfigUrl) {
        URL xmlConfigUrl = Log4JUtils.resolveXmlConfigUrl(defaultXmlConfigUrl);
        InputStream is = Log4JUtils.openConfig(xmlConfigUrl);
        try {
            Log4JUtils.configureRuntime(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configureRuntime log4j with " + xmlConfigUrl + ".", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureRuntime(@Nonnull InputStream log4jXmlConfigAsStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(log4jXmlConfigAsStream);
        try {
            Log4JUtils.configureRuntime(reader);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static void configureRuntime(@Nonnull Reader log4jXmlConfigAsReader) throws IOException {
        DOMConfigurator domConfigurator = new DOMConfigurator();
        domConfigurator.doConfigure(log4jXmlConfigAsReader, org.apache.log4j.LogManager.getLoggerRepository());
    }

    @Nonnull
    private static URL resolveXmlConfigUrl(@Nullable URL defaultXmlConfigUrl) {
        String plainConfigUrl = System.getProperty("log4j.configuration", defaultXmlConfigUrl != null ? defaultXmlConfigUrl.toExternalForm() : null);
        if (plainConfigUrl == null) {
            throw new IllegalArgumentException("The system property 'log4j.configuration' is not set.");
        }
        try {
            return new URL(plainConfigUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The given xmlConfig '" + plainConfigUrl + "' is no valid url.", e);
        }
    }

    @Nonnull
    private static InputStream openConfig(@Nonnull URL xmlConfigUrl) {
        InputStream is;
        try {
            is = xmlConfigUrl.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open xmlConfig '" + xmlConfigUrl + "'.", e);
        }
        return is;
    }

    private Log4JUtils() {
    }

    static {
        Log4JUtils.tryInstallJulToSlf4jBridge();
        Log4JUtils.tryFixMdcInSlf4j();
    }
}

