/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections15.IteratorUtils;
import org.apache.commons.lang3.StringUtils;

public class ManifestInformationFactory {
    public static final Attributes.Name IMPLEMENTATION_BUILD_REVISION = new Attributes.Name("Implementation-Build-Revision");
    public static final Attributes.Name IMPLEMENTATION_BUILD_DATE = new Attributes.Name("Implementation-Build-Date");
    private final String _resource;
    private final ClassLoader _classLoader;
    private volatile Manifest _manifest;
    private volatile String _applicationInfoString;

    public ManifestInformationFactory() {
        this(ManifestInformationFactory.class);
    }

    public ManifestInformationFactory(Class<?> baseClass) {
        this(baseClass.getName().replace('.', '/') + ".class", baseClass.getClassLoader());
    }

    public ManifestInformationFactory(String resource, ClassLoader classLoader) {
        this._resource = resource;
        this._classLoader = classLoader;
    }

    @Nullable
    public String getManifestValue(@Nonnull Attributes.Name mainAttributes) {
        Manifest manifest = this.getManifest();
        return this.getManifestValue(mainAttributes, manifest);
    }

    @Nullable
    protected String getManifestValue(@Nonnull Attributes.Name mainAttributes, @Nonnull Manifest of) {
        Object plainVersion = of.getMainAttributes().get(mainAttributes);
        String result = plainVersion != null ? plainVersion.toString() : null;
        return result;
    }

    @Nullable
    public String getImplementationVersion() {
        return this.getManifestValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    public String getImplementationTitle() {
        return this.getManifestValue(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    @Nullable
    public String getImplementationBuildRevision() {
        return this.getManifestValue(IMPLEMENTATION_BUILD_REVISION);
    }

    @Nullable
    public String getImplementationBuildDate() {
        return this.getManifestValue(IMPLEMENTATION_BUILD_DATE);
    }

    @Nullable
    public String getApplicationInfoString() {
        if (this._applicationInfoString == null) {
            String title = this.getImplementationTitle();
            String version = this.getImplementationVersion();
            String buildRevision = this.getImplementationBuildRevision();
            String buildDate = this.getImplementationBuildDate();
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)title)) {
                sb.append(title);
            }
            if (!StringUtils.isEmpty((CharSequence)version)) {
                if (!StringUtils.isEmpty((CharSequence)title)) {
                    sb.append(' ');
                }
                sb.append(version);
            }
            if (!StringUtils.isEmpty((CharSequence)buildDate) || !StringUtils.isEmpty((CharSequence)buildRevision)) {
                boolean surround;
                boolean bl = surround = sb.length() > 0;
                if (surround) {
                    sb.append(" (");
                }
                if (!StringUtils.isEmpty((CharSequence)buildRevision)) {
                    sb.append(buildRevision);
                }
                if (!StringUtils.isEmpty((CharSequence)buildDate)) {
                    if (!StringUtils.isEmpty((CharSequence)buildRevision)) {
                        sb.append(", ");
                    }
                    sb.append(buildDate);
                }
                if (surround) {
                    sb.append(')');
                }
            }
            this._applicationInfoString = sb.toString().trim();
        }
        return this._applicationInfoString.isEmpty() ? null : this._applicationInfoString;
    }

    @Nonnull
    public Manifest getManifest() {
        block16: {
            if (this._manifest == null) {
                URL manifestUrl = this.findManifestUrl();
                if (manifestUrl != null) {
                    try (InputStream is = manifestUrl.openStream();){
                        this._manifest = new Manifest(is);
                        break block16;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read manifest from " + manifestUrl + ".", e);
                    }
                }
                this._manifest = new Manifest();
            }
        }
        return this._manifest;
    }

    private URL findManifestUrl() {
        Iterator<URL> i = this.findResources(this._resource);
        if (!i.hasNext()) {
            throw new IllegalStateException("Could not find resource of " + this._resource + ".");
        }
        URL manifestUrl = null;
        while (i.hasNext() && manifestUrl == null) {
            URL classUrl = i.next();
            String base = this.getBaseFor(classUrl, this._resource);
            if (base == null) continue;
            manifestUrl = this.findManifestUrlStartsWith(base);
        }
        return manifestUrl;
    }

    private String getBaseFor(URL classUrl, String classResourceName) {
        String classUrlString = classUrl.toString();
        int cutBefore = classUrlString.lastIndexOf(classResourceName);
        String base = cutBefore > 0 && classUrlString.endsWith(classResourceName) ? classUrlString.substring(0, cutBefore) : null;
        return base;
    }

    private URL findManifestUrlStartsWith(String manifestUrlStartsWith) {
        URL manifestUrl = null;
        Iterator<URL> j = this.findResources("META-INF/MANIFEST.MF");
        while (j.hasNext() && manifestUrl == null) {
            URL currentManifestUrl = j.next();
            if (!currentManifestUrl.toString().startsWith(manifestUrlStartsWith)) continue;
            manifestUrl = currentManifestUrl;
        }
        return manifestUrl;
    }

    Iterator<URL> findResources(String name) {
        Iterator<URL> result = null;
        try {
            Enumeration<URL> enumeration = this._classLoader.getResources(name);
            if (enumeration != null) {
                result = IteratorUtils.asIterator(enumeration);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find all resources of " + name + ".", e);
        }
        if (result == null) {
            result = Collections.emptyIterator();
        }
        return result;
    }
}

