/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    public static void stop(@Nullable Iterable<? extends Thread> threads) {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.stop(thread);
            }
        }
    }

    public static void stop(@Nullable Thread thread) {
        if (thread != null) {
            if (thread instanceof AutoCloseable) {
                ResourceUtils.closeQuietly((AutoCloseable)((Object)thread));
            }
            thread.interrupt();
            try {
                while (thread.isAlive()) {
                    thread.join(TimeUnit.SECONDS.toMillis(10L));
                    if (!thread.isAlive()) continue;
                    Throwable throwable = new Throwable();
                    throwable.setStackTrace(thread.getStackTrace());
                    LOG.info("Still wait for termination of '" + thread.getName() + "'...", throwable);
                    thread.interrupt();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                LOG.debug("Could not wait for termination of '" + thread.getName() + "' - but this thread was interrupted.");
            }
        }
    }

    private ThreadUtils() {
    }
}

