/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.date;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.RangeSupport;
import org.echocat.jomon.runtime.util.SignificantableBasedOn;
import org.echocat.jomon.runtime.util.SignificantableWithMinAndMaxBasedOn;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class DateRange
extends RangeSupport<Date>
implements SignificantableWithMinAndMaxBasedOn<Date, Duration>,
SignificantableBasedOn<Duration> {
    protected static final Date MIN_DATE = new Date(0L);
    protected static final Date MAX_DATE = new Date(Long.MAX_VALUE);

    public DateRange(@Nullable @Including Date from, @Nullable @Excluding Date to) {
        super(from, to);
    }

    public boolean apply(@Nullable Date toTest) {
        return toTest != null && this.matchesFrom(toTest) && this.matchesTo(toTest);
    }

    protected boolean matchesFrom(@Nonnull Date toTest) {
        Date from = (Date)this.getFrom();
        return from == null || from.before(toTest) || from.equals(toTest);
    }

    protected boolean matchesTo(@Nonnull Date toTest) {
        Date to = (Date)this.getTo();
        return to == null || to.after(toTest);
    }

    @Override
    public boolean isSignificant(@Nonnull Duration base) {
        return this.isSignificant(MIN_DATE, MAX_DATE, base);
    }

    @Override
    public boolean isSignificant(@Nonnull Date minValue, @Nonnull Date maxValue, @Nonnull Duration base) {
        Date from = (Date)this.getFrom();
        Date to = (Date)this.getTo();
        Duration duration = new Duration(from != null ? from : minValue, to != null ? to : maxValue);
        return duration.isLessThanOrEqualTo(base);
    }

    public static class Adapter
    extends XmlAdapter<Container, DateRange> {
        public DateRange unmarshal(Container v) throws Exception {
            DateRange result = v != null ? new DateRange(v.getFrom(), v.getTo()) : null;
            return result;
        }

        public Container marshal(DateRange v) throws Exception {
            Container result;
            if (v != null) {
                result = new Container();
                result.setFrom((Date)v.getFrom());
                result.setTo((Date)v.getTo());
            } else {
                result = null;
            }
            return result;
        }
    }

    @XmlRootElement(name="dateRange")
    @XmlType(name="dateRange")
    public static class Container {
        private Date _from;
        private Date _to;

        @XmlAttribute(name="from")
        public Date getFrom() {
            return this._from;
        }

        public void setFrom(Date from) {
            this._from = from;
        }

        @XmlAttribute(name="to")
        public Date getTo() {
            return this._to;
        }

        public void setTo(Date to) {
            this._to = to;
        }
    }
}

