/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.generation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.generation.RangeRequirement;
import org.echocat.jomon.runtime.util.Range;

@ThreadSafe
@Immutable
public abstract class RangeRequirementSupport<T, R extends Range<T>>
implements RangeRequirement<T, R> {
    private final R _range;

    protected RangeRequirementSupport(@Nonnull R range) {
        this._range = range;
    }

    @Override
    @Nonnull
    public R getValue() {
        return this._range;
    }

    protected static abstract class Adapter<T, C extends Container<T>, R extends Range<T>>
    extends XmlAdapter<C, R> {
        protected Adapter() {
        }

        public R unmarshal(C v) throws Exception {
            R result = v != null ? (R)this.newRangeRequirement(((Container)v).getFrom(), ((Container)v).getTo()) : null;
            return result;
        }

        public C marshal(R v) throws Exception {
            Container result;
            if (v != null) {
                result = (Container)this.newContainer();
                result.setFrom(v.getFrom());
                result.setTo(v.getTo());
            } else {
                result = null;
            }
            return (C)result;
        }

        @Nonnull
        protected abstract C newContainer();

        @Nonnull
        protected abstract R newRangeRequirement(@Nullable @Including T var1, @Nullable @Excluding T var2);
    }

    protected static abstract class Container<T> {
        private T _from;
        private T _to;

        protected Container() {
        }

        @XmlAttribute(name="from")
        public T getFrom() {
            return this._from;
        }

        public void setFrom(T from) {
            this._from = from;
        }

        @XmlAttribute(name="to")
        public T getTo() {
            return this._to;
        }

        public void setTo(T to) {
            this._to = to;
        }
    }
}

