/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.i18n;

import com.google.common.collect.Iterators;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.i18n.ResourceBundles;
import org.echocat.jomon.runtime.util.Entry;

public class CompoundResourceBundle
extends ResourceBundle {
    private final ResourceBundles _resourceBundles;
    private final Locale _locale;

    public CompoundResourceBundle(@Nonnull ResourceBundles resourceBundles, @Nonnull Locale locale) {
        this._resourceBundles = resourceBundles;
        this._locale = locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException("This implementation of " + ResourceBundle.class.getName() + " could not handle null keys.");
        }
        return this._resourceBundles.get(this._locale, key);
    }

    @Override
    public Enumeration<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Entry<Locale, ResourceBundle> localeAndBundle : this._resourceBundles) {
            ResourceBundle bundle = localeAndBundle.getValue();
            keys.addAll(bundle.keySet());
        }
        return Iterators.asEnumeration(keys.iterator());
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }
}

