/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public abstract class BatchConvertingIterator<S, T>
implements CloseableIterator<T> {
    private final int _batchSize;
    private final Iterator<S> _input;
    private Iterator<T> _output;

    protected BatchConvertingIterator(@Nonnull Iterator<S> input, @Nonnegative int batchSize) {
        this._input = input;
        this._batchSize = batchSize;
    }

    @Nonnull
    protected abstract Iterator<T> convert(@Nonnull Collection<S> var1);

    @Override
    public boolean hasNext() {
        if ((this._output == null || !this._output.hasNext()) && this._input.hasNext()) {
            this._output = this.prepareAndProcessBatch();
        }
        return this._output != null && this._output.hasNext();
    }

    @Override
    @Nullable
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no further elements.");
        }
        return this._output.next();
    }

    @Override
    public void remove() {
        if (this._output == null) {
            throw new NoSuchElementException("This iterator has no elements.");
        }
        this._output.remove();
    }

    @Nonnull
    private Iterator<T> prepareAndProcessBatch() {
        ArrayList<S> batch = new ArrayList<S>(this._batchSize);
        for (int a = 0; a < this._batchSize && this._input.hasNext(); ++a) {
            S entry = this._input.next();
            if (entry == null) continue;
            batch.add(entry);
        }
        Iterator<T> iterator = this.convert(batch);
        return iterator;
    }

    @Override
    public void close() {
        ResourceUtils.closeQuietly(this._input);
    }
}

