/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.LimitedIterator;
import org.echocat.jomon.runtime.repository.Paged;

public class PagedIterator<T>
implements CloseableIterator<T> {
    private final Iterator<T> _inputIterator;

    protected PagedIterator(@Nullable Iterator<T> inputIterator, @Nullable Paged paged) {
        this._inputIterator = new LimitedIterator<T>(inputIterator, paged);
        this.skip(paged);
    }

    protected void skip(@Nullable Paged paged) {
        this.skip(paged != null ? paged.getEntriesToSkip() : null);
    }

    protected void skip(@Nullable Long entriesToSkip) {
        if (entriesToSkip != null) {
            for (long i = 0L; i < entriesToSkip; ++i) {
                if (!this._inputIterator.hasNext()) continue;
                this._inputIterator.next();
            }
        }
    }

    @Override
    public void close() {
        if (this._inputIterator instanceof CloseableIterator) {
            ((CloseableIterator)this._inputIterator).close();
        }
    }

    @Override
    public boolean hasNext() {
        return this._inputIterator.hasNext();
    }

    @Override
    public T next() {
        return this._inputIterator.next();
    }

    @Override
    public void remove() {
        this._inputIterator.remove();
    }
}

