/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public abstract class ResultSetIterator<R>
implements CloseableIterator<R> {
    private final ResultSet _resultSet;
    private Boolean _hasNext;

    protected ResultSetIterator(@Nonnull ResultSet resultSet) {
        this._resultSet = resultSet;
    }

    public abstract R convert(@Nonnull ResultSet var1) throws SQLException;

    @Override
    public boolean hasNext() {
        if (this._hasNext == null) {
            try {
                this._hasNext = this._resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not retrieve next row of " + this._resultSet + ".", e);
            }
        }
        return this._hasNext;
    }

    @Override
    public R next() {
        R result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            result = this.convert(this._resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not convert current row of " + this._resultSet + ".", e);
        }
        this._hasNext = null;
        return result;
    }

    @Override
    public void close() {
        ResourceUtils.closeQuietly(this._resultSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

