/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.NumberRange;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class DoubleRange
extends NumberRange<Double> {
    public DoubleRange(@Nullable @Including Double from, @Nullable @Excluding Double to) {
        super(from, to);
    }

    @Override
    protected boolean isGreaterThan(@Nonnull Double what, @Nonnull Double as) {
        return what > as;
    }

    @Override
    public boolean isSignificant(@Nonnull Double minValue, @Nonnull Double maxValue, @Nonnull Double base) {
        Double from = (Double)this.getFrom();
        Double to = (Double)this.getTo();
        double range = (to != null ? to : maxValue) - (from != null ? from : minValue);
        return range <= base;
    }

    public static class Adapter
    extends NumberRange.Adapter<Double, Container, DoubleRange> {
        @Override
        @Nonnull
        protected Container newContainer() {
            return new Container();
        }

        @Override
        @Nonnull
        protected DoubleRange newNumberRange(@Nullable @Including Double from, @Nullable @Excluding Double to) {
            return new DoubleRange(from, to);
        }
    }

    @XmlRootElement(name="doubleRange")
    @XmlType(name="doubleRange")
    public static class Container
    extends NumberRange.Container<Double> {
    }
}

