/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.util.RangeSupport;
import org.echocat.jomon.runtime.util.SignificantableWithMinAndMaxBasedOn;

@ThreadSafe
@Immutable
public abstract class NumberRange<N extends Number>
extends RangeSupport<N>
implements SignificantableWithMinAndMaxBasedOn<N, N> {
    protected NumberRange(@Nullable @Including N from, @Nullable @Excluding N to) {
        super(from, to);
        if (from != null && to != null && this.isGreaterThan(from, to)) {
            throw new IllegalArgumentException("From value (" + from + ") is greater than to value (" + to + ")");
        }
    }

    public boolean apply(@Nullable N toTest) {
        return this.matchesFrom(toTest) && this.matchesTo(toTest);
    }

    protected boolean matchesFrom(@Nonnull N toTest) {
        Number from = (Number)this.getFrom();
        return from == null || this.isGreaterThan(toTest, from) || from.equals(toTest);
    }

    protected boolean matchesTo(@Nonnull N toTest) {
        Number to = (Number)this.getTo();
        return to == null || this.isGreaterThan(to, toTest);
    }

    protected abstract boolean isGreaterThan(@Nonnull N var1, @Nonnull N var2);

    @Override
    public abstract boolean isSignificant(@Nonnull N var1, @Nonnull N var2, @Nonnull N var3);

    protected static abstract class Adapter<N extends Number, C extends Container<N>, NR extends NumberRange<N>>
    extends XmlAdapter<C, NR> {
        protected Adapter() {
        }

        public NR unmarshal(C v) throws Exception {
            NR result = v != null ? (NR)this.newNumberRange(((Container)v).getFrom(), ((Container)v).getTo()) : null;
            return result;
        }

        public C marshal(NR v) throws Exception {
            Container result;
            if (v != null) {
                result = (Container)this.newContainer();
                result.setFrom((Number)((RangeSupport)v).getFrom());
                result.setTo((Number)((RangeSupport)v).getTo());
            } else {
                result = null;
            }
            return (C)result;
        }

        @Nonnull
        protected abstract C newContainer();

        @Nonnull
        protected abstract NR newNumberRange(@Nullable @Including N var1, @Nullable @Excluding N var2);
    }

    protected static abstract class Container<N extends Number> {
        private N _from;
        private N _to;

        protected Container() {
        }

        public N getFrom() {
            return this._from;
        }

        public void setFrom(N from) {
            this._from = from;
        }

        public N getTo() {
            return this._to;
        }

        public void setTo(N to) {
            this._to = to;
        }
    }
}

