/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.StringUtils;
import org.echocat.jomon.runtime.util.GotInterruptedException;

@XmlJavaTypeAdapter(value=Adapter.class)
@Immutable
@ThreadSafe
public class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = 3L;
    private final long _milliSeconds;

    public static void sleep(@Nonnull String duration) throws InterruptedException {
        Duration.sleep(new Duration(duration));
    }

    public static void sleep(@Nonnull Duration duration) throws InterruptedException {
        Duration.sleep(duration.toMilliSeconds());
    }

    public static void sleep(@Nonnegative long amount, @Nonnull TimeUnit unit) throws InterruptedException {
        Duration.sleep(unit.toMillis(amount));
    }

    public static void sleep(@Nonnegative long milliSeconds) throws InterruptedException {
        if (milliSeconds > 0L) {
            Thread.sleep(milliSeconds);
        }
    }

    public static void sleepSafe(@Nonnull String duration) throws GotInterruptedException {
        Duration.sleepSafe(new Duration(duration));
    }

    public static void sleepSafe(@Nonnull Duration duration) throws GotInterruptedException {
        Duration.sleepSafe(duration.toMilliSeconds());
    }

    public static void sleepSafe(@Nonnegative long amount, @Nonnull TimeUnit unit) throws GotInterruptedException {
        Duration.sleepSafe(unit.toMillis(amount));
    }

    public static void sleepSafe(@Nonnegative long milliSeconds) throws GotInterruptedException {
        try {
            Duration.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new GotInterruptedException(e);
        }
    }

    @Nonnull
    public static Duration duration(@Nonnull Duration duration) {
        return duration;
    }

    @Nullable
    public static Duration duration(@Nullable String duration) {
        return duration != null ? new Duration(duration) : null;
    }

    @Nullable
    public static Duration duration(@Nonnegative long duration) {
        return new Duration(duration);
    }

    @Nonnull
    public static Duration durationOf(@Nonnull Duration duration) {
        return Duration.duration(duration);
    }

    @Nullable
    public static Duration durationOf(@Nullable String duration) {
        return Duration.duration(duration);
    }

    @Nullable
    public static Duration durationOf(@Nonnegative long duration) {
        return Duration.duration(duration);
    }

    public static Duration since(long startTime) {
        long now = System.currentTimeMillis();
        return new Duration(now - startTime);
    }

    public Duration(@Nonnegative long milliSeconds) {
        this._milliSeconds = milliSeconds;
    }

    public Duration(@Nonnegative long duration, TimeUnit durationUnit) {
        this._milliSeconds = durationUnit.toMillis(duration);
    }

    public Duration(@Nonnull String plain) throws IllegalArgumentException {
        this._milliSeconds = Duration.parsePattern(plain);
    }

    public Duration(@Nonnull Date from, @Nonnull Date to) {
        if (from.after(to)) {
            throw new IllegalArgumentException("From " + from + " is after to " + to + "?");
        }
        this._milliSeconds = to.getTime() - from.getTime();
    }

    @Nonnull
    public Duration plus(@Nullable String duration) {
        return this.plus(duration != null ? new Duration(duration) : null);
    }

    @Nonnull
    public Duration plus(@Nullable Duration duration) {
        return this.plus(duration != null ? duration.toMilliSeconds() : 0L);
    }

    @Nonnull
    public Duration plus(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.plus(unit.toMillis(amount));
    }

    @Nonnull
    public Duration plus(@Nonnegative long milliSeconds) {
        return new Duration(this.toMilliSeconds() + milliSeconds);
    }

    @Nonnull
    public Duration minus(@Nullable String duration) {
        return this.minus(duration != null ? new Duration(duration) : null);
    }

    @Nonnull
    public Duration minus(@Nullable Duration duration) {
        return this.minus(duration != null ? duration.toMilliSeconds() : 0L);
    }

    @Nonnull
    public Duration minus(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.minus(unit.toMillis(amount));
    }

    @Nonnull
    public Duration minus(@Nonnegative long milliSeconds) {
        return this.plus(milliSeconds * -1L);
    }

    @Nonnull
    public Duration multiplyBy(double what) {
        return new Duration(Math.round((double)this._milliSeconds * what));
    }

    @Nonnull
    public Duration dividedBy(double what) {
        return new Duration(Math.round((double)this._milliSeconds / what));
    }

    @Nonnull
    public Duration multiplyBy(long what) {
        return new Duration(Math.round(this._milliSeconds * what));
    }

    @Nonnull
    public Duration dividedBy(long what) {
        return new Duration(Math.round(this._milliSeconds / what));
    }

    @Nonnegative
    public long toMilliSeconds() {
        return this._milliSeconds;
    }

    @Nonnegative
    public long in(@Nonnull TimeUnit timeUnit) {
        return timeUnit.convert(this.toMilliSeconds(), TimeUnit.MILLISECONDS);
    }

    @Nonnull
    public String toPattern() {
        return Duration.toPattern(this.toMilliSeconds());
    }

    @Nonnull
    public Map<TimeUnit, Long> toUnitToValue() {
        return Duration.toUnitToValue(this.toMilliSeconds());
    }

    public boolean isEmpty() {
        return this.toMilliSeconds() <= 0L;
    }

    public boolean hasContent() {
        return this.toMilliSeconds() > 0L;
    }

    public boolean isLessThan(@Nullable String other) {
        return this.isLessThan(other != null ? new Duration(other) : null);
    }

    public boolean isLessThan(@Nullable Duration other) {
        return this.isLessThan(other != null ? other.toMilliSeconds() : 0L);
    }

    public boolean isLessThan(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isLessThan(unit.toMillis(amount));
    }

    public boolean isLessThan(@Nonnegative long milliSeconds) {
        return this.toMilliSeconds() < milliSeconds;
    }

    public boolean isLessThanOrEqualTo(@Nullable String other) {
        return this.isLessThanOrEqualTo(other != null ? new Duration(other) : null);
    }

    public boolean isLessThanOrEqualTo(@Nullable Duration other) {
        return this.isLessThanOrEqualTo(other != null ? other.toMilliSeconds() : 0L);
    }

    public boolean isLessThanOrEqualTo(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isLessThanOrEqualTo(unit.toMillis(amount));
    }

    public boolean isLessThanOrEqualTo(@Nonnegative long milliSeconds) {
        return this.toMilliSeconds() <= milliSeconds;
    }

    public boolean isGreaterThan(@Nullable String other) {
        return this.isGreaterThan(other != null ? new Duration(other) : null);
    }

    public boolean isGreaterThan(@Nullable Duration other) {
        return this.isGreaterThan(other != null ? other.toMilliSeconds() : 0L);
    }

    public boolean isGreaterThan(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isGreaterThan(unit.toMillis(amount));
    }

    public boolean isGreaterThan(@Nonnegative long milliSeconds) {
        return this.toMilliSeconds() > milliSeconds;
    }

    public boolean isGreaterThanOrEqualTo(@Nullable String other) {
        return this.isGreaterThanOrEqualTo(other != null ? new Duration(other) : null);
    }

    public boolean isGreaterThanOrEqualTo(@Nullable Duration other) {
        return this.isGreaterThanOrEqualTo(other != null ? other.toMilliSeconds() : 0L);
    }

    public boolean isGreaterThanOrEqualTo(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isGreaterThanOrEqualTo(unit.toMillis(amount));
    }

    public boolean isGreaterThanOrEqualTo(@Nonnegative long milliSeconds) {
        return this.toMilliSeconds() >= milliSeconds;
    }

    public void sleep() throws InterruptedException {
        Duration.sleep(this);
    }

    public void sleepUnchecked() throws GotInterruptedException {
        Duration.sleepSafe(this);
    }

    @Override
    public int compareTo(Duration other) {
        int result = Duration.compare(this.toMilliSeconds(), other != null ? other.toMilliSeconds() : 0L);
        return result;
    }

    private static int compare(long self, long other) {
        int result = self < other ? -1 : (self == other ? 0 : 1);
        return result;
    }

    public int hashCode() {
        long milliSeconds = this.toMilliSeconds();
        return (int)(milliSeconds ^ milliSeconds >>> 32);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o instanceof Duration) {
            Duration other = (Duration)o;
            result = this.toMilliSeconds() == other.toMilliSeconds();
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return this.toPattern();
    }

    @Nonnegative
    protected static long oneUncheckedIntervalToMilliSeconds(@Nonnull String interval) {
        String trimmedInterval = interval.trim();
        return trimmedInterval.isEmpty() ? 0L : Duration.oneIntervalToMilliSeconds(interval);
    }

    @Nonnegative
    protected static long oneIntervalToMilliSeconds(@Nonnull String interval) {
        long value;
        try {
            value = Long.valueOf(interval);
        }
        catch (NumberFormatException ignored) {
            if (interval.length() >= 2) {
                long plainValue;
                try {
                    plainValue = Long.valueOf(interval.substring(0, interval.length() - 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Don't know how to convert: " + interval, e);
                }
                String mode = interval.substring(interval.length() - 1);
                if (mode.equals("S")) {
                    value = plainValue;
                }
                if (mode.equals("s")) {
                    value = TimeUnit.SECONDS.toMillis(plainValue);
                }
                if (mode.equals("m")) {
                    value = TimeUnit.MINUTES.toMillis(plainValue);
                }
                if (mode.equals("h")) {
                    value = TimeUnit.HOURS.toMillis(plainValue);
                }
                if (mode.equals("d")) {
                    value = TimeUnit.DAYS.toMillis(plainValue);
                }
                if (mode.equals("w")) {
                    value = TimeUnit.DAYS.toMillis(plainValue) * 7L;
                }
                throw new IllegalArgumentException("Don't know how to convert: " + interval);
            }
            throw new IllegalArgumentException("Don't know how to convert: " + interval);
        }
        return value;
    }

    @Nonnegative
    protected static long parsePattern(@Nonnull String pattern) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        char[] chars = pattern.replace("ms", "S").toCharArray();
        long result = 0L;
        for (char c : chars) {
            if (Character.isWhitespace(c)) {
                result += Duration.oneUncheckedIntervalToMilliSeconds(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c == 'w' || c == 'd' || c == 'h' || c == 'm' || c == 's' || c == 'S') {
                sb.append(c);
                result += Duration.oneUncheckedIntervalToMilliSeconds(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            throw new IllegalArgumentException("Don't know how to convert: " + pattern);
        }
        return result;
    }

    @Nonnull
    protected static String toPattern(@Nonnegative long milliseconds) {
        long days = milliseconds / 1000L / 60L / 60L / 24L;
        long hours = milliseconds / 1000L / 60L / 60L - days * 24L;
        long minutes = milliseconds / 1000L / 60L - days * 24L * 60L - hours * 60L;
        long seconds = milliseconds / 1000L - minutes * 60L - hours * 60L * 60L - days * 24L * 60L * 60L;
        long ms = milliseconds - seconds * 1000L - minutes * 60L * 1000L - hours * 1000L * 60L * 60L - days * 24L * 60L * 60L * 1000L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            StringUtils.addElement(sb, " ", days + "d");
        }
        if (hours > 0L) {
            StringUtils.addElement(sb, " ", hours + "h");
        }
        if (minutes > 0L) {
            StringUtils.addElement(sb, " ", minutes + "m");
        }
        if (seconds > 0L) {
            StringUtils.addElement(sb, " ", seconds + "s");
        }
        if (ms > 0L) {
            StringUtils.addElement(sb, " ", ms + "ms");
        }
        if (sb.length() == 0) {
            sb.append("0ms");
        }
        return sb.toString();
    }

    @Nonnull
    protected static Map<TimeUnit, Long> toUnitToValue(@Nonnegative long milliseconds) {
        long days = milliseconds / 1000L / 60L / 60L / 24L;
        long hours = milliseconds / 1000L / 60L / 60L - days * 24L;
        long minutes = milliseconds / 1000L / 60L - days * 24L * 60L - hours * 60L;
        long seconds = milliseconds / 1000L - minutes * 60L - hours * 60L * 60L - days * 24L * 60L * 60L;
        long ms = milliseconds - seconds * 1000L - minutes * 60L * 1000L - hours * 1000L * 60L * 60L - days * 24L * 60L * 60L * 1000L;
        LinkedHashMap<TimeUnit, Long> result = new LinkedHashMap<TimeUnit, Long>(5, 1.0f);
        if (days > 0L) {
            result.put(TimeUnit.DAYS, days);
        }
        if (hours > 0L) {
            result.put(TimeUnit.HOURS, hours);
        }
        if (minutes > 0L) {
            result.put(TimeUnit.MINUTES, minutes);
        }
        if (seconds > 0L) {
            result.put(TimeUnit.SECONDS, seconds);
        }
        if (ms > 0L) {
            result.put(TimeUnit.MILLISECONDS, ms);
        }
        return Collections.unmodifiableMap(result);
    }

    public static class Adapter
    extends XmlAdapter<String, Duration> {
        public Duration unmarshal(String v) throws Exception {
            return v != null ? new Duration(v) : null;
        }

        public String marshal(Duration v) throws Exception {
            return v != null ? v.toPattern() : null;
        }
    }
}

