/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnull;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.DurationRange;
import org.echocat.jomon.runtime.util.DurationRangeRequirement;
import org.echocat.jomon.runtime.util.DurationRequirement;
import org.echocat.jomon.runtime.util.ExactDurationRequirement;
import org.echocat.jomon.runtime.util.IncreasingDurationRequirement;

public class DurationGenerator
implements Generator<Duration, DurationRequirement> {
    private static final RandomData RANDOM = new RandomDataImpl();
    private static final DurationGenerator INSTANCE = new DurationGenerator();

    @Nonnull
    public static Duration generateDuration(@Nonnull DurationRequirement requirement) {
        return INSTANCE.generate(requirement);
    }

    @Override
    @Nonnull
    public Duration generate(@Nonnull DurationRequirement requirement) {
        Duration duration;
        if (requirement instanceof ExactDurationRequirement) {
            duration = this.generateExact((ExactDurationRequirement)requirement);
        } else if (requirement instanceof DurationRangeRequirement) {
            duration = this.generateInRange((DurationRangeRequirement)requirement);
        } else if (requirement instanceof IncreasingDurationRequirement) {
            duration = this.generateIncreasingDuration((IncreasingDurationRequirement)requirement);
        } else {
            throw new IllegalArgumentException("Don't know how to handle requirement: " + requirement);
        }
        return duration;
    }

    @Nonnull
    protected Duration generateExact(@Nonnull ExactDurationRequirement requirement) {
        return (Duration)requirement.getValue();
    }

    @Nonnull
    protected Duration generateInRange(@Nonnull DurationRangeRequirement requirement) {
        DurationRange range = (DurationRange)requirement.getValue();
        Duration from = (Duration)range.getFrom();
        Duration to = (Duration)range.getTo();
        long milliseconds = RANDOM.nextSecureLong(from != null ? from.toMilliSeconds() : 0L, to != null ? to.toMilliSeconds() : Long.MAX_VALUE);
        return new Duration(milliseconds);
    }

    @Nonnull
    protected Duration generateIncreasingDuration(@Nonnull IncreasingDurationRequirement requirement) {
        return requirement.next();
    }
}

