/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.util.Range;

@ThreadSafe
@Immutable
public abstract class RangeSupport<V>
implements Range<V> {
    private final V _from;
    private final V _to;

    public RangeSupport(@Nullable @Including V from, @Nullable @Excluding V to) {
        this._from = from;
        this._to = to;
    }

    @Override
    @Nullable
    public V getFrom() {
        return this._from;
    }

    @Nonnull
    public V getFrom(@Nonnull V defValue) {
        return this._from != null ? this._from : defValue;
    }

    @Override
    @Nullable
    public V getTo() {
        return this._to;
    }

    @Nonnull
    public V getTo(@Nonnull V defValue) {
        return this._to != null ? this._to : defValue;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof Range)) {
            result = false;
        } else {
            Range that = (Range)o;
            V from = this.getFrom();
            V to = this.getTo();
            result = (from != null ? from.equals(that.getFrom()) : that.getFrom() == null) && (to != null ? to.equals(that.getTo()) : that.getTo() == null);
        }
        return result;
    }

    public int hashCode() {
        V from = this.getFrom();
        V to = this.getTo();
        int result = from != null ? from.hashCode() : 0;
        result = 31 * result + (to != null ? to.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this._from + " to " + this._to;
    }
}

