/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.ExtendingHints;
import org.echocat.jomon.runtime.util.Hint;
import org.echocat.jomon.runtime.util.Hints;

public class StackedByThreadHints
extends Hints {
    private final ThreadLocal<Deque<Hints>> _hintStack = new ThreadLocal();
    private final Hints _superHints;

    public StackedByThreadHints(@Nullable Hints superHints) {
        this._superHints = superHints;
    }

    public StackedByThreadHints pushStackElement() {
        return this.pushStackElement(null);
    }

    public StackedByThreadHints pushStackElement(@Nullable Hints hints) {
        Deque<Hints> allHints = this._hintStack.get();
        if (allHints == null) {
            allHints = new ArrayDeque<Hints>();
            this._hintStack.set(allHints);
        }
        allHints.addLast(this._superHints != null ? new ExtendingHints(this._superHints, hints) : hints);
        return this;
    }

    public StackedByThreadHints popStackElement() {
        Deque<Hints> allHints = this._hintStack.get();
        allHints.removeLast();
        if (allHints.isEmpty()) {
            this._hintStack.remove();
        }
        return this;
    }

    @Override
    public <T> T get(@Nonnull Hint<T> hint, @Nullable T defaultValue) {
        return this.getCurrent().get(hint, defaultValue);
    }

    @Override
    public <T> void remove(@Nonnull Hint<T> hint) {
        this.getCurrent().remove(hint);
    }

    @Override
    public boolean isSet(@Nonnull Hint<?> hint) {
        return this.getCurrent().isSet(hint);
    }

    @Override
    public Iterator<Entry<Hint<?>, Object>> iterator() {
        return this.getCurrent().iterator();
    }

    @Nonnull
    protected Hints getCurrent() {
        Deque<Hints> allHints = this._hintStack.get();
        return allHints != null && !allHints.isEmpty() ? allHints.getLast() : this._superHints;
    }
}

