/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.CacheSupport;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.Value;
import org.echocat.jomon.runtime.util.ValueProducer;

public class CombinedCache<K, V>
extends CacheSupport<K, V> {
    private final Cache<? extends K, ? extends V>[] _delegates;

    public CombinedCache(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType, Cache<? extends K, ? extends V> ... delegates) {
        super(keyType, valueType);
        this._delegates = delegates != null ? delegates : new Cache[]{};
    }

    @Override
    public void put(@Nullable K key, @Nullable V value) {
        this.checkKey(key);
        this.checkValue(value);
        for (Cache<? extends K, ? extends V> delegate : this._delegates) {
            this.cast(delegate).put(key, value);
        }
    }

    @Override
    public void put(@Nullable K key, @Nullable V value, @Nullable Duration expireAfter) {
        this.checkKey(key);
        this.checkValue(value);
        for (Cache<? extends K, ? extends V> delegate : this._delegates) {
            this.cast(delegate).put(key, value, expireAfter);
        }
    }

    @Override
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer, @Nullable Duration expireAfter) {
        Cache<? extends K, ? extends V> delegate;
        Cache<K, V> cache;
        this.checkKey(key);
        Object result = null;
        HashSet<Cache<K, V>> missedOn = new HashSet<Cache<K, V>>(this._delegates.length);
        Cache<? extends K, ? extends V>[] arr$ = this._delegates;
        int n = arr$.length;
        for (int i$ = 0; i$ < n && (result = (Object)(cache = this.cast(delegate = arr$[i$])).get(key)) == null; ++i$) {
            missedOn.add(cache);
        }
        if (result == null && cacheValueProducer != null) {
            result = new Value.Lazy(key, cacheValueProducer, ProducingType.nonBlocking).getValue();
        }
        if (result != null) {
            for (Cache cache2 : missedOn) {
                cache2.put(key, result, expireAfter);
            }
        }
        return (V)result;
    }

    @Override
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer) {
        return this.get(key, cacheValueProducer, null);
    }

    @Override
    public V get(@Nullable K key) {
        return this.get(key, null);
    }

    @Override
    public Value<V> remove(@Nullable K key) {
        this.checkKey(key);
        Value<? extends V> result = null;
        for (Cache<? extends K, ? extends V> delegate : this._delegates) {
            Value<? extends V> removed = this.cast(delegate).remove(key);
            if (removed == null) continue;
            result = removed;
        }
        return result;
    }

    @Override
    public boolean contains(@Nullable K key) {
        this.checkKey(key);
        boolean result = false;
        for (Cache<? extends K, ? extends V> delegate : this._delegates) {
            if (!this.cast(delegate).contains(key)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nonnull
    protected Cache<K, V> cast(Cache<? extends K, ? extends V> delegate) {
        return delegate;
    }

    @Nonnull
    public Cache<K, V>[] getDelegates() {
        return this._delegates;
    }
}

