/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.cache.CacheEntry;
import org.echocat.jomon.cache.CacheListener;
import org.echocat.jomon.cache.CacheListenerInvoker;
import org.echocat.jomon.cache.CacheSupport;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.IdentifiedCache;
import org.echocat.jomon.cache.KeysEnabledCache;
import org.echocat.jomon.cache.LimitedCache;
import org.echocat.jomon.cache.ListenerEnabledCache;
import org.echocat.jomon.cache.ProducingTypeEnabledCache;
import org.echocat.jomon.cache.StatisticsEnabledCache;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.Value;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.jomon.runtime.util.ValueProducingFailedException;

@ThreadSafe
public abstract class InMemoryBasedCacheSupport<K, V>
extends CacheSupport<K, V>
implements StatisticsEnabledCache<K, V>,
LimitedCache<K, V>,
ClearableCache<K, V>,
ListenerEnabledCache<K, V>,
IdentifiedCache<K, V>,
ProducingTypeEnabledCache<K, V>,
KeysEnabledCache<K, V>,
AutoCloseable {
    protected final Object _lock = new Object();
    protected final CacheListenerInvoker _listenerInvoker = new CacheListenerInvoker();
    protected final long _createdTimestamp;
    protected String _id;
    protected Map<K, CacheEntry<K, V>> _entries;
    protected Integer _capacity;
    protected Duration _defaultExpireAfter;
    private ProducingType _producingType = ProducingType.DEFAULT;
    protected long _numberOfRequests = 0L;
    protected long _numberOfHits = 0L;
    protected long _numberOfDrops;
    protected CacheEntry<K, V> _first = null;
    protected CacheEntry<K, V> _last = null;
    protected long _nearstExpiringTime;

    protected InMemoryBasedCacheSupport(@Nonnull Class<? extends K> keyType, @Nonnull Class<? extends V> valueType) {
        super(keyType, valueType);
        this._createdTimestamp = System.currentTimeMillis();
        this._entries = new HashMap<K, CacheEntry<K, V>>();
        this._nearstExpiringTime = System.currentTimeMillis();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public Duration getMaximumLifetime() {
        return this._defaultExpireAfter;
    }

    @Override
    public Long getCapacity() {
        return this._capacity != null ? Long.valueOf(this._capacity.longValue()) : null;
    }

    @Override
    public void setListeners(@Nullable Collection<CacheListener> listeners) {
        this._listenerInvoker.setListeners(listeners);
    }

    @Override
    public Collection<CacheListener> getListeners() {
        return this._listenerInvoker.getListeners();
    }

    @Override
    @Nonnull
    public ProducingType getProducingType() {
        return this._producingType;
    }

    @Override
    public void setProducingType(@Nonnull ProducingType producingType) {
        if (producingType == null) {
            throw new NullPointerException();
        }
        this._producingType = producingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLast() {
        CacheEntry<K, V> entry;
        Object object = this._lock;
        synchronized (object) {
            if (this._last != null) {
                entry = this._entries.remove(this._last.getKey());
                this.setLast(this._last.getPrevious());
            } else {
                entry = null;
            }
            if (this.size() == 0L) {
                this._first = null;
                this._last = null;
            }
        }
        if (entry != null) {
            this.handleRemove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpLifetimeExpired() {
        long currentTime = System.currentTimeMillis();
        if (this._nearstExpiringTime > 0L && this._nearstExpiringTime <= currentTime) {
            ArrayList<K> keysToRemove = new ArrayList<K>();
            Object object = this._lock;
            synchronized (object) {
                this._nearstExpiringTime = 0L;
                for (CacheEntry<K, V> cacheEntry : this._entries.values()) {
                    Long expire = cacheEntry.getExpire();
                    if (expire == null) continue;
                    long unboxedExpire = expire;
                    if (unboxedExpire <= currentTime) {
                        keysToRemove.add(cacheEntry.getKey());
                        continue;
                    }
                    if (this._nearstExpiringTime != 0L && unboxedExpire >= this._nearstExpiringTime) continue;
                    this._nearstExpiringTime = unboxedExpire;
                }
                for (CacheEntry<K, V> key : keysToRemove) {
                    this.removeInternal(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this._listenerInvoker.beforeClear(this)) {
            Map<K, CacheEntry<K, V>> oldEntries;
            Object object = this._lock;
            synchronized (object) {
                oldEntries = this._entries;
                this._entries = new HashMap<K, CacheEntry<K, V>>();
                this._first = null;
                this._last = null;
                this.resetStatistics();
            }
            for (CacheEntry<K, V> entry : oldEntries.values()) {
                try {
                    this.handleRemove(entry);
                }
                catch (ValueProducingFailedException ignored) {}
            }
            this._listenerInvoker.afterClear(this);
        }
    }

    protected abstract void updateListAfterHit(CacheEntry<K, V> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Object value;
        this.checkKey(key);
        if (this._listenerInvoker.beforeGet(this, key)) {
            CacheEntry<K, V> cacheEntry;
            CacheEntry<K, V> outdatedCacheEntry = null;
            Object object = this._lock;
            synchronized (object) {
                ++this._numberOfRequests;
                cacheEntry = this._entries.get(key);
                if (cacheEntry != null) {
                    if (this.isOutDated(cacheEntry)) {
                        outdatedCacheEntry = this.internalRemove(key);
                        cacheEntry = null;
                    } else {
                        ++this._numberOfHits;
                        cacheEntry.hit();
                        this.updateListAfterHit(cacheEntry);
                    }
                }
            }
            if (outdatedCacheEntry != null) {
                this.handleRemove(outdatedCacheEntry);
            }
            Value<V> valueHolder = cacheEntry == null ? null : cacheEntry.getValue();
            value = valueHolder != null ? valueHolder.getValue() : null;
            this._listenerInvoker.afterGet(this, key, valueHolder);
        } else {
            value = null;
        }
        return (V)value;
    }

    @Override
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer) {
        return this.get(key, cacheValueProducer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@Nullable K key, @Nullable ValueProducer<K, V> cacheValueProducer, @Nullable Duration expireAfter) {
        Object value;
        this.checkKey(key);
        if (this._listenerInvoker.beforeGet(this, key)) {
            CacheEntry<K, V> cacheEntry;
            CacheEntry<K, V> outdatedCacheEntry = null;
            Object object = this._lock;
            synchronized (object) {
                ++this._numberOfRequests;
                cacheEntry = this._entries.get(key);
                if (cacheEntry != null) {
                    if (this.isOutDated(cacheEntry)) {
                        outdatedCacheEntry = this.internalRemove(key);
                        cacheEntry = null;
                    } else {
                        ++this._numberOfHits;
                        cacheEntry.hit();
                        this.updateListAfterHit(cacheEntry);
                    }
                }
                if (cacheEntry == null && cacheValueProducer != null) {
                    cacheEntry = new CacheEntry<K, V>(key, this.getTargetExpireAfterBasedOn(expireAfter), cacheValueProducer, this._producingType);
                    this.internalPut(cacheEntry);
                }
            }
            if (outdatedCacheEntry != null) {
                this.handleRemove(outdatedCacheEntry);
            }
            Value<V> valueHolder = cacheEntry != null ? cacheEntry.getValue() : null;
            value = valueHolder != null ? valueHolder.getValue() : null;
            this.checkValueAfterProducing(value);
            this._listenerInvoker.afterGet(this, key, valueHolder);
        } else {
            value = null;
        }
        return (V)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this.checkKey(key);
        Object object = this._lock;
        synchronized (object) {
            this.get(key);
            return this._entries.containsKey(key);
        }
    }

    protected abstract void updateListAfterPut(CacheEntry<K, V> var1);

    @Override
    public void put(@Nullable K key, @Nullable V value) {
        this.put(key, value, null);
    }

    @Override
    public void put(@Nullable K key, @Nullable V value, @Nullable Duration expireAfter) {
        this.checkKey(key);
        this.checkValue(value);
        Value.Fixed fixed = new Value.Fixed(value);
        if (this._listenerInvoker.beforePut(this, key, (Value<?>)fixed, expireAfter)) {
            Long targetExpireAfter = this.getTargetExpireAfterBasedOn(expireAfter);
            CacheEntry<K, V> newEntry = new CacheEntry<K, V>(key, targetExpireAfter, value);
            this.internalPut(newEntry);
            this._listenerInvoker.afterPut(this, key, (Value<?>)fixed, expireAfter);
        }
    }

    @Nullable
    protected Long getTargetExpireAfterBasedOn(@Nullable Duration expireAfter) {
        Duration defaultExpireAfter;
        Long targetExpireAfter = expireAfter != null ? Long.valueOf(expireAfter.in(TimeUnit.MILLISECONDS)) : ((defaultExpireAfter = this._defaultExpireAfter) != null ? Long.valueOf(defaultExpireAfter.in(TimeUnit.MILLISECONDS)) : null);
        return targetExpireAfter;
    }

    @Override
    @Nullable
    public Value<V> remove(@Nullable K key) {
        Value<V> result;
        this.checkKey(key);
        if (this._listenerInvoker.beforeRemove(this, key)) {
            result = this.removeInternal(key);
            this._listenerInvoker.afterRemove(this, key, result);
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    protected Value<V> removeInternal(@Nullable K key) {
        Value<V> result;
        CacheEntry<K, V> removedCacheEntry = this.internalRemove(key);
        if (removedCacheEntry == null) {
            result = null;
        } else {
            result = removedCacheEntry.getValue();
            this.handleRemove(removedCacheEntry);
        }
        return result;
    }

    protected void handleRemove(@Nullable CacheEntry<K, V> cacheEntry) {
        ++this._numberOfDrops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFirst(@Nullable CacheEntry<K, V> cacheEntry) {
        Object object = this._lock;
        synchronized (object) {
            if (cacheEntry == null) {
                this._first = null;
                this._last = null;
            } else {
                if (this._first == null) {
                    this._last = cacheEntry;
                    this._last.setNext(null);
                }
                this._first = cacheEntry;
                this._first.setPrevious(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLast(@Nullable CacheEntry<K, V> cacheEntry) {
        Object object = this._lock;
        synchronized (object) {
            if (this._last == null) {
                this._first = cacheEntry;
                if (this._first != null) {
                    this._first.setPrevious(null);
                }
            }
            this._last = cacheEntry;
            if (this._last != null) {
                this._last.setNext(null);
            }
        }
    }

    @Override
    public void setMaximumLifetime(@Nullable Duration maxLifetime) {
        if (this._listenerInvoker.beforeSetMaximumLifetime(this, maxLifetime)) {
            this._defaultExpireAfter = maxLifetime;
            this._listenerInvoker.afterSetMaximumLifetime(this, maxLifetime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCapacity(@Nullable Long capacity) {
        ArrayList<CacheEntry<K, V>> toCleanUp;
        if (capacity != null && capacity > Integer.valueOf(Integer.MAX_VALUE).longValue()) {
            throw new IllegalArgumentException("The capacity does not reach 2147483647.");
        }
        Object object = this._lock;
        synchronized (object) {
            this._capacity = capacity != null ? Integer.valueOf(capacity.intValue()) : null;
            Map<K, CacheEntry<K, V>> map = this._entries;
            toCleanUp = new ArrayList<CacheEntry<K, V>>();
            this._entries = this._capacity != null ? new HashMap(this._capacity, 1.0f) : new HashMap();
            int i = 0;
            for (Map.Entry<K, CacheEntry<K, V>> entry : map.entrySet()) {
                if ((long)i < capacity) {
                    this._entries.put(entry.getKey(), entry.getValue());
                } else {
                    toCleanUp.add(entry.getValue());
                }
                ++i;
            }
        }
        for (CacheEntry cacheEntry : toCleanUp) {
            try {
                this.handleRemove(cacheEntry);
            }
            catch (ValueProducingFailedException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long size() {
        Object object = this._lock;
        synchronized (object) {
            return this._entries.size();
        }
    }

    @Override
    public Long getNumberOfHits() {
        return this._numberOfHits;
    }

    @Override
    public Long getNumberOfRequests() {
        return this._numberOfRequests;
    }

    @Override
    public Long getNumberOfDrops() {
        return this._numberOfDrops;
    }

    @Override
    public Date getCreated() {
        return new Date(this._createdTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry<K, V> getFirst() {
        Object object = this._lock;
        synchronized (object) {
            return this._first;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry<K, V> getLast() {
        Object object = this._lock;
        synchronized (object) {
            return this._last;
        }
    }

    protected Object getLock() {
        return this._lock;
    }

    protected Map<K, CacheEntry<K, V>> getEntries() {
        return this._entries;
    }

    private boolean isOutDated(CacheEntry<K, V> cacheEntry) {
        Long expire = cacheEntry.getExpire();
        return expire != null && expire <= System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry<K, V> internalRemove(K key) {
        CacheEntry<K, V> entry;
        Object object = this._lock;
        synchronized (object) {
            if (this._entries.isEmpty()) {
                this._first = null;
                this._last = null;
                entry = null;
            } else {
                entry = this._entries.remove(key);
                if (entry != null) {
                    if (entry == this._first) {
                        this.setFirst(this._first.getNext());
                    } else if (entry == this._last) {
                        this.setLast(this._last.getPrevious());
                    } else {
                        CacheEntry<K, V> previous = entry.getPrevious();
                        CacheEntry<K, V> next = entry.getNext();
                        previous.setNext(next);
                        next.setPrevious(previous);
                    }
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPut(CacheEntry<K, V> newEntry) {
        Object object = this._lock;
        synchronized (object) {
            CacheEntry<K, V> oldEntry;
            Integer maxSize = this._capacity;
            if (maxSize != null && this.size() >= (long)maxSize.intValue()) {
                this.cleanUpLifetimeExpired();
                if (this.size() >= (long)maxSize.intValue()) {
                    this.removeLast();
                }
            }
            K key = newEntry.getKey();
            Long expire = newEntry.getExpire();
            if (this._nearstExpiringTime > 0L && expire != null && expire <= this._nearstExpiringTime) {
                this._nearstExpiringTime = expire;
            }
            if ((oldEntry = this._entries.put(key, newEntry)) != null) {
                this._entries.put(key, oldEntry);
                this.handleRemove(oldEntry);
                oldEntry.setValue(newEntry.getExpire(), newEntry.getValue());
                ++this._numberOfHits;
                oldEntry.hit();
                this.updateListAfterHit(oldEntry);
            } else {
                this.updateListAfterPut(newEntry);
            }
        }
    }

    @Override
    public void resetStatistics() {
        if (this._listenerInvoker.beforeResetStatistics(this)) {
            this._numberOfDrops = 0L;
            this._numberOfHits = 0L;
            this._numberOfRequests = 0L;
            this._listenerInvoker.afterResetStatistics(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIterator<K> iterator() {
        HashSet<K> keys;
        Object object = this._lock;
        synchronized (object) {
            keys = new HashSet<K>(this._entries.keySet());
        }
        return CollectionUtils.asCloseableIterator(keys.iterator());
    }

    @Override
    public void close() throws Exception {
        this.clear();
    }
}

