/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.CombinedCache;
import org.echocat.jomon.cache.management.CacheDefinition;

public class CombinedCacheDefinition<K, V>
extends CacheDefinition<K, V, CombinedCacheDefinition<K, V>> {
    private List<IdentifiersToDefinition<? extends K, ? extends V>> _delegates;

    @Nonnull
    public static <K, V> CombinedCacheDefinition<K, V> combinedCache(@Nonnull Class<K> keyType, @Nonnull Class<V> valueType, IdentifiersToDefinition<? extends K, ? extends V> ... delegates) {
        CombinedCacheDefinition<? extends K, ? extends V> definition = new CombinedCacheDefinition<K, V>(keyType, valueType);
        definition.withDelegates(delegates);
        return definition;
    }

    @Nonnull
    public static <K, V> CombinedCacheDefinition<K, V> combinedCacheOf(@Nonnull Class<K> keyType, @Nonnull Class<V> valueType, IdentifiersToDefinition<? extends K, ? extends V> ... delegates) {
        return CombinedCacheDefinition.combinedCache(keyType, valueType, delegates);
    }

    @Nonnull
    public static <K, V> TypeAndVariantToDefinition<K, V> with(@Nonnull Class<?> forType, @Nonnull CacheDefinition<K, V, ?> definition) {
        return CombinedCacheDefinition.with(forType, null, definition);
    }

    @Nonnull
    public static <K, V> TypeAndVariantToDefinition<K, V> with(@Nonnull Class<?> forType, @Nullable String variant, @Nonnull CacheDefinition<K, V, ?> definition) {
        return new TypeAndVariantToDefinition<K, V>(forType, variant, definition);
    }

    @Nonnull
    public static <K, V> IdToDefinition<K, V> with(@Nonnull String id, @Nonnull CacheDefinition<K, V, ?> definition) {
        return new IdToDefinition<K, V>(id, definition);
    }

    public CombinedCacheDefinition(@Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        super(CombinedCache.class, keyType, valueType);
    }

    public List<IdentifiersToDefinition<? extends K, ? extends V>> getDelegates() {
        return this._delegates;
    }

    public void setDelegates(List<IdentifiersToDefinition<? extends K, ? extends V>> delegates) {
        this._delegates = delegates != null ? new ArrayList<IdentifiersToDefinition<K, V>>(delegates) : null;
    }

    @Nonnull
    public CombinedCacheDefinition<K, V> withDelegate(@Nonnull IdentifiersToDefinition<? extends K, ? extends V> delegate) {
        return this.withDelegates(delegate);
    }

    @Nonnull
    public CombinedCacheDefinition<K, V> withDelegates(IdentifiersToDefinition<? extends K, ? extends V> ... delegates) {
        if (this._delegates == null) {
            this._delegates = new ArrayList<IdentifiersToDefinition<? extends K, ? extends V>>();
        }
        this._delegates.addAll(Arrays.asList(delegates));
        return (CombinedCacheDefinition)this.thisInstance();
    }

    public static class TypeAndVariantToDefinition<K, V>
    extends IdentifiersToDefinition<K, V> {
        private final Class<?> _forType;
        private final String _variant;

        public TypeAndVariantToDefinition(@Nonnull Class<?> forType, @Nullable String variant, @Nonnull CacheDefinition<K, V, ?> definition) {
            super(definition);
            this._forType = forType;
            this._variant = variant;
        }

        @Nonnull
        public Class<?> getForType() {
            return this._forType;
        }

        @Nullable
        public String getVariant() {
            return this._variant;
        }
    }

    public static class IdToDefinition<K, V>
    extends IdentifiersToDefinition<K, V> {
        private final String _id;

        public IdToDefinition(@Nonnull String id, @Nonnull CacheDefinition<K, V, ?> definition) {
            super(definition);
            this._id = id;
        }

        @Nonnull
        public String getId() {
            return this._id;
        }
    }

    public static abstract class IdentifiersToDefinition<K, V> {
        private final CacheDefinition<K, V, ?> _definition;

        public IdentifiersToDefinition(@Nonnull CacheDefinition<K, V, ?> definition) {
            this._definition = definition;
        }

        @Nonnull
        public CacheDefinition<K, V, ?> getDefinition() {
            return this._definition;
        }
    }
}

