/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.cache.management;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.runtime.util.Duration;

public abstract class LimitedCacheDefinition<K, V, T extends LimitedCacheDefinition<K, V, T>>
extends CacheDefinition<K, V, T> {
    private Long _capacity;
    private Duration _maximumLifetime;

    public LimitedCacheDefinition(@Nonnull Class<? extends Cache<?, ?>> requiredType, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        super(requiredType, keyType, valueType);
    }

    @Nonnull
    public T withCapacity(@Nonnegative long capacity) {
        this.setCapacity(capacity);
        return (T)((LimitedCacheDefinition)this.thisInstance());
    }

    @Nonnull
    public T withMaximumLifetime(@Nonnull Duration maximumLifetime) {
        this.setMaximumLifetime(maximumLifetime);
        return (T)((LimitedCacheDefinition)this.thisInstance());
    }

    @Nonnull
    public T withMaximumLifetime(@Nonnull String maximumLifetime) {
        return this.withMaximumLifetime(new Duration(maximumLifetime));
    }

    @Nonnull
    public T withMaximumLifetime(@Nonnegative long maximumLifetime) {
        return this.withMaximumLifetime(new Duration(maximumLifetime));
    }

    public void setCapacity(@Nullable Long capacity) {
        this._capacity = capacity;
    }

    public void setMaximumLifetime(@Nullable Duration maximumLifetime) {
        this._maximumLifetime = maximumLifetime;
    }

    @Nullable
    public Long getCapacity() {
        return this._capacity;
    }

    @Nullable
    public Duration getMaximumLifetime() {
        return this._maximumLifetime;
    }
}

