/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.codec.Md5;
import org.echocat.jomon.runtime.codec.Md5Utils;

public abstract class Md5Support
implements Md5 {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    @Override
    @Nonnull
    public Md5 update(@Nullable String with) {
        this.update(with, DEFAULT_CHARSET);
        return this;
    }

    @Override
    @Nonnull
    public Md5Support update(@Nullable String with, @Nonnull Charset charset) {
        if (with != null) {
            byte[] bytes = with.getBytes(charset);
            this.update(bytes, 0, bytes.length);
        }
        return this;
    }

    @Override
    @Nonnull
    public Md5 update(byte with) {
        this.update(new byte[]{with}, 0, 1);
        return this;
    }

    @Override
    @Nonnull
    public Md5 update(@Nullable byte[] with) {
        if (with != null) {
            this.update(with, 0, with.length);
        }
        return this;
    }

    @Override
    @Nonnull
    public Md5 update(@Nullable @WillNotClose InputStream is) throws IOException {
        if (is != null) {
            byte[] buffer = new byte[4096];
            int read = is.read(buffer);
            while (read > -1) {
                this.update(buffer, 0, read);
                read = is.read(buffer);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public Md5 update(@Nullable File file) throws IOException {
        if (file != null) {
            try (FileInputStream is = new FileInputStream(file);){
                this.update(is);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public char[] asHexCharacters() {
        return Md5Utils.asHexCharacters(this.asBytes());
    }

    @Override
    @Nonnull
    public String asHexString() {
        return Md5Utils.asHexString(this.asBytes());
    }
}

