/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BatchedHitWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedHitWriter.class);
    private final Lock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    private volatile Duration _cycleInterval = new Duration("15s");
    private volatile int _maxQueueSize = 1000;
    private volatile String _name = "Hits";
    private Map<Object, Hits<?>> _keyToHits = new HashMap();
    private Thread _cyclerThread;

    @Nonnull
    public Duration getCycleInterval() {
        return this._cycleInterval;
    }

    public void setCycleInterval(@Nonnull Duration cycleInterval) {
        this._cycleInterval = cycleInterval;
    }

    @Nonnegative
    public int getMaxQueueSize() {
        return this._maxQueueSize;
    }

    public void setMaxQueueSize(@Nonnegative int maxQueueSize) {
        this._maxQueueSize = maxQueueSize;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(@Nonnull String name) {
        this._name = name;
        BatchedHitWriter batchedHitWriter = this;
        synchronized (batchedHitWriter) {
            if (this._cyclerThread != null) {
                this._cyclerThread.setName(name + ".Cycler");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        BatchedHitWriter batchedHitWriter = this;
        synchronized (batchedHitWriter) {
            if (this._cyclerThread != null) {
                throw new IllegalStateException("The recorder was already initialized.");
            }
            this._cyclerThread = new Thread((Runnable)new Cycler(), this._name + ".Cycler");
            this._cyclerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroy() {
        BatchedHitWriter batchedHitWriter = this;
        synchronized (batchedHitWriter) {
            block9: {
                try {
                    if (this._cyclerThread == null) break block9;
                    try {
                        this._cyclerThread.interrupt();
                        while (!Thread.currentThread().isInterrupted() && this._cyclerThread.isAlive()) {
                            this._cyclerThread.join(10L);
                            if (!this._cyclerThread.isAlive()) continue;
                            LOG.info("Still wait for termination of " + this._cyclerThread + "...");
                            this._cyclerThread.interrupt();
                        }
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        LOG.debug("Could not wait for termination of " + this._cyclerThread + ". This thread was interrupted.");
                    }
                }
                finally {
                    this._cyclerThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> void recordHitOf(@Nonnull K key, @Nonnull HitWriter<K> writer) {
        this._lock.lock();
        try {
            Hits<K> hits = this.getHitsFor(key);
            hits.record(writer);
            this._condition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    @Nonnull
    @GuardedBy(value="_lock")
    protected <K> Hits<K> getHitsFor(@Nonnull K key) {
        Hits<Object> hits = this._keyToHits.get(key);
        if (hits == null) {
            hits = new Hits<K>(key);
            this._keyToHits.put(key, hits);
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Map<Object, Hits<?>> cycleKeyToHits() {
        Map<Object, Hits<?>> oldKeyToHits;
        HashMap newKeyToHits = new HashMap();
        this._lock.lock();
        try {
            oldKeyToHits = this._keyToHits;
            this._keyToHits = newKeyToHits;
        }
        finally {
            this._lock.unlock();
        }
        return oldKeyToHits;
    }

    @Nonnull
    protected Map<HitWriter<?>, Set<Hits<?>>> groupByWriter(@Nonnull Map<Object, Hits<?>> keyToHits) {
        HashMap result = new HashMap();
        for (Map.Entry<Object, Hits<?>> keyAndHits : keyToHits.entrySet()) {
            Hits<?> hits = keyAndHits.getValue();
            for (HitWriter<?> writer : hits.getWriters()) {
                HashSet groupedKeyToHits = (HashSet)result.get(writer);
                if (groupedKeyToHits == null) {
                    groupedKeyToHits = new HashSet();
                    result.put(writer, groupedKeyToHits);
                }
                groupedKeyToHits.add(hits);
            }
        }
        return result;
    }

    @Nonnull
    protected Map<HitWriter<?>, Set<Hits<?>>> getWriterToHitsForNextCycle() {
        Map<Object, Hits<?>> keyToHits = this.cycleKeyToHits();
        return this.groupByWriter(keyToHits);
    }

    public void cycle() {
        try {
            Map<HitWriter<?>, Set<Hits<?>>> writerToKeyToHits = this.getWriterToHitsForNextCycle();
            for (Map.Entry<HitWriter<?>, Set<Hits<?>>> writerAndHits : writerToKeyToHits.entrySet()) {
                HitWriter<?> writer = writerAndHits.getKey();
                Set hits = writerAndHits.getValue();
                writer.write(hits);
            }
        }
        catch (ServiceTemporaryUnavailableException e) {
            LOG.warn("Could not record the hits. This hits are lost now and will not be rescheduled. This is only a problem for statistics.", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "{" + this._name + "}";
    }

    protected class Cycler
    implements Runnable {
        protected Cycler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long lastUpdate = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                Duration interval = BatchedHitWriter.this._cycleInterval;
                int maxQueueSize = BatchedHitWriter.this._maxQueueSize;
                try {
                    if (this.isLastUpdateLongAgo(interval, lastUpdate) || this.isQueueToBig(BatchedHitWriter.this._keyToHits, maxQueueSize)) {
                        BatchedHitWriter.this.cycle();
                        lastUpdate = System.currentTimeMillis();
                    }
                    BatchedHitWriter.this._lock.lockInterruptibly();
                    try {
                        BatchedHitWriter.this._condition.await(interval.toMilliSeconds() - (System.currentTimeMillis() - lastUpdate), TimeUnit.MILLISECONDS);
                    }
                    finally {
                        BatchedHitWriter.this._lock.unlock();
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        protected void waitForSpecifiedInterval() {
            try {
                Thread.sleep(BatchedHitWriter.this._cycleInterval.toMilliSeconds());
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isQueueToBig(@Nonnull Map<Object, Hits<?>> elements, @Nonnegative int maxSize) {
            BatchedHitWriter.this._lock.lock();
            try {
                boolean bl = elements.size() >= maxSize;
                return bl;
            }
            finally {
                BatchedHitWriter.this._lock.unlock();
            }
        }

        protected boolean isLastUpdateLongAgo(@Nonnull Duration touchFilesNotLaterThan, @Nonnegative long lastUpdate) {
            return lastUpdate + touchFilesNotLaterThan.toMilliSeconds() <= System.currentTimeMillis();
        }
    }

    public static interface HitWriter<K> {
        public void write(@Nonnull Set<Hits<K>> var1);
    }

    @NotThreadSafe
    public static class Hits<K> {
        private final Set<HitWriter<K>> _writers = new HashSet<HitWriter<K>>();
        private final K _key;
        private volatile long _hits;
        private volatile Date _lastAccessed;

        public Hits(@Nullable K key) {
            this._key = key;
        }

        @Nullable
        public K getKey() {
            return this._key;
        }

        @Nonnegative
        public long getHits() {
            return this._hits;
        }

        @Nonnull
        public Date getLastAccessed() {
            return this._lastAccessed;
        }

        public void record(@Nonnull HitWriter<K> writer) {
            this._writers.add(writer);
            ++this._hits;
            this._lastAccessed = new Date();
        }

        @Nonnull
        protected Set<HitWriter<K>> getWriters() {
            return this._writers;
        }
    }
}

