/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.concurrent.LockFactory;
import org.echocat.jomon.runtime.util.Duration;

public class LockFactoryAdapter
implements LockFactory {
    @Nonnull
    private final Lock _delegate;
    @Nonnull
    private final LockFactory.Lock _lock;

    public LockFactoryAdapter(@Nonnull Lock delegate) {
        this._delegate = delegate;
        this._lock = this.createLock();
    }

    @Nonnull
    protected LockFactory.Lock createLock() {
        return new LockAdapter();
    }

    @Override
    @Nonnull
    public LockFactory.Lock lock() {
        this._delegate.lock();
        return this._lock;
    }

    @Override
    @Nonnull
    public LockFactory.Lock lockInterruptibly() throws InterruptedException {
        this._delegate.lockInterruptibly();
        return this._lock;
    }

    @Override
    @Nullable
    public LockFactory.Lock tryLock() {
        return this._delegate.tryLock() ? this._lock : null;
    }

    @Override
    @Nullable
    public LockFactory.Lock tryLock(@Nonnegative long time, @Nonnull TimeUnit unit) throws InterruptedException {
        return this._delegate.tryLock(time, unit) ? this._lock : null;
    }

    @Override
    @Nullable
    public LockFactory.Lock tryLock(@Nonnull Duration timeout) throws InterruptedException {
        return this._delegate.tryLock(timeout.toMilliSeconds(), TimeUnit.MILLISECONDS) ? this._lock : null;
    }

    @Override
    @Nonnull
    public Condition newCondition() {
        return this._delegate.newCondition();
    }

    public class LockAdapter
    implements LockFactory.Lock {
        @Override
        public void close() {
            LockFactoryAdapter.this._delegate.unlock();
        }
    }
}

