/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.Duration;

@ThreadSafe
public class StopWatch {
    @Nonnegative
    private long _startedNanos;
    @Nonnegative
    private long _baseNanos;

    @Nonnull
    public static StopWatch startStopWatch() {
        return StopWatch.startStopWatch(null);
    }

    @Nonnull
    public static StopWatch startStopWatch(@Nullable Duration base) {
        return new StopWatch(base);
    }

    public StopWatch() {
        this(true, null);
    }

    public StopWatch(boolean start) {
        this(start, null);
    }

    public StopWatch(@Nullable Duration base) {
        this(true, base);
    }

    public StopWatch(boolean start, @Nullable Duration base) {
        this._startedNanos = start ? System.nanoTime() : 0L;
        this._baseNanos = base != null ? base.in(TimeUnit.NANOSECONDS) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Duration getCurrentDuration() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            long durationInNanos = (this._startedNanos > 0L ? System.nanoTime() - this._startedNanos : 0L) + this._baseNanos;
            long milliSeconds = durationInNanos / 1000000L;
            int nanoSeconds = (int)(durationInNanos - milliSeconds * 1000000L);
            return new Duration(milliSeconds, nanoSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public StopWatch reset() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            if (this._startedNanos > 0L) {
                this._startedNanos = System.nanoTime();
            }
            this._baseNanos = 0L;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public StopWatch pause() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            this._baseNanos += System.nanoTime() - this._startedNanos;
            this._startedNanos = 0L;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public StopWatch start() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            this._startedNanos = System.nanoTime();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            return this._startedNanos > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StopWatch stopWatch = this;
        synchronized (stopWatch) {
            return this.isRunning() ? this.getCurrentDuration().toString() : "paused";
        }
    }
}

