/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.exceptions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExceptionUtils {
    @Nullable
    public static <T extends Throwable> T findExceptionInCausesOf(@Nonnull Throwable start, @Nonnull Class<T> expectedType) {
        Throwable current = start;
        Throwable result = null;
        while (result == null && current != null) {
            if (expectedType.isInstance(current)) {
                result = (Throwable)expectedType.cast(current);
                continue;
            }
            if (current.equals(current.getCause())) {
                current = null;
                continue;
            }
            current = current.getCause();
        }
        return (T)result;
    }

    public static boolean containsException(@Nonnull Throwable start, @Nonnull Class<? extends Throwable> ofType) {
        return ExceptionUtils.findExceptionInCausesOf(start, ofType) != null;
    }

    public static boolean matches(@Nonnull ClassNotFoundException cnfe, @Nonnull String classNamePrefix) {
        String message = cnfe.getMessage();
        return message != null && message.startsWith(classNamePrefix);
    }

    public static boolean containsClassNotFoundException(@Nonnull Throwable start, @Nonnull String classNamePrefix) {
        ClassNotFoundException cnfe = ExceptionUtils.findExceptionInCausesOf(start, ClassNotFoundException.class);
        return cnfe != null && ExceptionUtils.matches(cnfe, classNamePrefix);
    }

    private ExceptionUtils() {
    }
}

