/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.generation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.echocat.jomon.runtime.generation.OneOfRequirement;

@ThreadSafe
@Immutable
public abstract class OneOfRequirementSupport<T>
implements OneOfRequirement<T> {
    private final Set<T> _oneOf;

    public OneOfRequirementSupport(@Nonnull Collection<T> possibleValues) {
        if (possibleValues.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one gender.");
        }
        this._oneOf = new HashSet<T>(possibleValues);
    }

    public OneOfRequirementSupport(@Nonnull T first, T ... others) {
        this._oneOf = new HashSet<T>();
        this._oneOf.add(first);
        if (others != null) {
            this._oneOf.addAll(Arrays.asList(others));
        }
    }

    @Override
    @Nonnull
    public Set<T> getPossibleValues() {
        return Collections.unmodifiableSet(this._oneOf);
    }

    protected static abstract class Adapter<T, C extends Container<T>, R extends OneOfRequirementSupport<T>>
    extends XmlAdapter<C, R> {
        protected Adapter() {
        }

        public R unmarshal(C v) throws Exception {
            R result = v != null ? (R)this.newOneOfRequirement(((Container)v).getPossibleValues()) : null;
            return result;
        }

        public C marshal(R v) throws Exception {
            Container result;
            if (v != null) {
                result = (Container)this.newContainer();
                result.setPossibleValues(((OneOfRequirementSupport)v).getPossibleValues());
            } else {
                result = null;
            }
            return (C)result;
        }

        @Nonnull
        protected abstract C newContainer();

        @Nonnull
        protected abstract R newOneOfRequirement(@Nullable Set<T> var1);
    }

    protected static abstract class Container<T> {
        private Set<T> _possibleValues;

        protected Container() {
        }

        @XmlElement(name="possibleValues")
        public Set<T> getPossibleValues() {
            return this._possibleValues;
        }

        public void setPossibleValues(Set<T> possibleValues) {
            this._possibleValues = possibleValues;
        }
    }
}

