/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

public interface Redirection
extends Closeable {

    public static abstract class CompoundSupport<T extends Redirection>
    implements Redirection {
        private final List<T> _delegates;

        public CompoundSupport(@Nullable Iterable<T> delegates) {
            this._delegates = CollectionUtils.asImmutableList(delegates);
        }

        @Nonnull
        protected List<T> getDelegates() {
            return this._delegates;
        }

        @Override
        public void close() throws IOException {
            ArrayList<Throwable> throwables = new ArrayList<Throwable>();
            for (Redirection delegate : this._delegates) {
                try {
                    delegate.close();
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
            if (!throwables.isEmpty()) {
                Throwable first = (Throwable)throwables.get(0);
                if (first instanceof IOException) {
                    throw (IOException)first;
                }
                if (first instanceof RuntimeException) {
                    throw (RuntimeException)first;
                }
                if (first instanceof Error) {
                    throw (Error)first;
                }
                throw new IOException(first.getMessage(), first);
            }
        }
    }

    public static abstract class LoggerBasedSupport
    implements Redirection {
        @Nonnull
        private final String _fqcn = this.getClass().getName();
        @Nonnull
        private final Logger _logger;
        @Nonnull
        private final LogLevel _logLevel;

        public LoggerBasedSupport(@Nonnull Logger logger, @Nonnull LogLevel logLevel) {
            this._logger = logger;
            this._logLevel = logLevel;
        }

        @Nonnull
        protected Logger getLogger() {
            return this._logger;
        }

        protected void log(@Nullable String message) {
            if (this._logger instanceof LocationAwareLogger) {
                Slf4jUtils.log((LocationAwareLogger)this._logger, this._logLevel, this._fqcn, null, message, null, null);
            } else {
                Slf4jUtils.log(this._logger, this._logLevel, message);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static abstract class StreamBasedSupport<S extends Closeable>
    implements Redirection {
        @Nonnull
        private final S _stream;
        private final boolean _closeStream;

        public StreamBasedSupport(@Nonnull S stream, boolean closeStream) {
            this._stream = stream;
            this._closeStream = closeStream;
        }

        @Nonnull
        public S getStream() {
            return this._stream;
        }

        @Override
        public void close() throws IOException {
            if (this._closeStream) {
                this._stream.close();
            }
        }
    }

    public static interface Out
    extends Redirection {
        public static final Out stdout = new StreamBasedSupport(System.out, false);
        public static final Out stderr = new StreamBasedSupport(System.err, false);
        public static final Out noop = new Out(){

            @Override
            public void send(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };

        public void send(@Nonnull byte[] var1, @Nonnegative int var2, @Nonnegative int var3) throws IOException;

        public void flush() throws IOException;

        public static class StreamAdapter
        extends OutputStream {
            private final Out _out;

            @Nonnull
            public static OutputStream outputStreamFor(@Nonnull Out out) {
                return out instanceof StreamBasedSupport ? (OutputStream)((StreamBasedSupport)out).getStream() : new StreamAdapter(out);
            }

            public StreamAdapter(@Nonnull Out out) {
                this._out = out;
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this._out.send(b, off, len);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this._out.close();
                }
            }
        }

        public static class Compound
        extends CompoundSupport<Out>
        implements Out {
            @Nonnull
            public static Out outOf(Out ... delegates) {
                return new Compound(delegates);
            }

            @Nonnull
            public static Out outOf(@Nullable Iterable<Out> delegates) {
                return new Compound(delegates);
            }

            public Compound(Out ... delegates) {
                this((Iterable<Out>)CollectionUtils.asImmutableList(delegates));
            }

            public Compound(@Nullable Iterable<Out> delegates) {
                super(delegates);
            }

            @Override
            public void send(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
                for (Out delegate : this.getDelegates()) {
                    delegate.send(bytes, offset, length);
                }
            }

            @Override
            public void flush() throws IOException {
                for (Out delegate : this.getDelegates()) {
                    delegate.flush();
                }
            }
        }

        public static class LoggerBasedSupport
        extends org.echocat.jomon.runtime.io.Redirection$LoggerBasedSupport
        implements Out {
            public LoggerBasedSupport(@Nonnull Logger logger, @Nonnull LogLevel logLevel) {
                super(logger, logLevel);
            }

            @Override
            public void send(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
                this.log(new String(bytes, offset, length));
            }

            @Override
            public void flush() throws IOException {
            }
        }

        public static class StreamBasedSupport
        extends org.echocat.jomon.runtime.io.Redirection$StreamBasedSupport<OutputStream>
        implements Out {
            public StreamBasedSupport(@Nonnull OutputStream stream) {
                this(stream, true);
            }

            public StreamBasedSupport(@Nonnull OutputStream stream, boolean closeStream) {
                super(stream, closeStream);
            }

            @Override
            public void send(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
                ((OutputStream)this.getStream()).write(bytes, offset, length);
            }

            @Override
            public void flush() throws IOException {
                ((OutputStream)this.getStream()).flush();
            }
        }

        public static class ByteArrayOut
        extends StreamBasedSupport {
            public ByteArrayOut() {
                super(new ByteArrayOutputStream());
            }

            @Nonnull
            public byte[] toByteArray() {
                return ((ByteArrayOutputStream)this.getStream()).toByteArray();
            }

            public String toString() {
                return ((OutputStream)this.getStream()).toString();
            }

            @Nonnull
            public String toString(@Nonnull Charset charset) {
                byte[] bytes = this.toByteArray();
                return new String(bytes, 0, bytes.length, charset);
            }
        }
    }

    public static interface In
    extends Redirection {
        public static final In stdin = new StreamBasedSupport(System.in, false);
        public static final In noop = new In(){

            @Override
            public int receive(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
                return -1;
            }

            @Override
            public void close() throws IOException {
            }
        };

        public int receive(@Nonnull byte[] var1, @Nonnegative int var2, @Nonnegative int var3) throws IOException;

        public static class StreamAdapter
        extends InputStream {
            private final In _in;

            @Nonnull
            public static InputStream inputStreamFor(@Nonnull In in) {
                return in instanceof StreamBasedSupport ? (InputStream)((StreamBasedSupport)in).getStream() : new StreamAdapter(in);
            }

            public StreamAdapter(@Nonnull In in) {
                this._in = in;
            }

            @Override
            public int read() throws IOException {
                byte[] bytes = new byte[1];
                int read = this.read(bytes, 0, 1);
                return read < 0 ? -1 : 0xFF & bytes[0];
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this._in.receive(b, off, len);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this._in.close();
                }
            }
        }

        public static class StreamBasedSupport
        extends org.echocat.jomon.runtime.io.Redirection$StreamBasedSupport<InputStream>
        implements In {
            public StreamBasedSupport(@Nonnull InputStream stream) {
                this(stream, true);
            }

            public StreamBasedSupport(@Nonnull InputStream stream, boolean closeStream) {
                super(stream, closeStream);
            }

            @Override
            public int receive(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int length) throws IOException {
                return ((InputStream)this.getStream()).read(bytes, offset, length);
            }
        }
    }
}

