/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class IteratorUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loopOverAllElementsOf(@Nullable Iterator<?> i) {
        try {
            if (i != null) {
                while (i.hasNext()) {
                    i.next();
                }
            }
        }
        finally {
            if (i instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)i)).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Nonnull
    public static <T> CloseableIterator<T> emptyCloseableIterator() {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nonnull
    public static <T> CloseableIterator<T> toCloseableIterator(final @Nonnull Iterator<T> original) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
                ResourceUtils.closeQuietlyIfAutoCloseable((Object)original);
            }

            @Override
            public boolean hasNext() {
                return original.hasNext();
            }

            @Override
            public T next() {
                return original.next();
            }

            @Override
            public void remove() {
                original.remove();
            }
        };
    }

    @Nonnull
    public static <T> CloseableIterator<T> toCloseableIterator(final @Nonnull Iterator<T> original, final @Nullable AutoCloseable toClose) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
                if (toClose != null) {
                    ResourceUtils.closeQuietly(toClose);
                }
            }

            @Override
            public boolean hasNext() {
                return original.hasNext();
            }

            @Override
            public T next() {
                return original.next();
            }

            @Override
            public void remove() {
                original.remove();
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> CloseableIterator<T> toCloseableIterator(T ... items) {
        CloseableIterator<T> result = items == null || items.length == 0 ? IteratorUtils.emptyCloseableIterator() : IteratorUtils.toCloseableIterator(Iterators.forArray((Object[])items));
        return result;
    }

    @Nonnull
    public static <T> CloseableIterator<T> filter(final @Nonnull Iterator<T> unfiltered, final @Nonnull Predicate<? super T> predicate) {
        AbstractIterator i = new AbstractIterator<T>(){

            protected T computeNext() {
                Object result = null;
                boolean found = false;
                while (unfiltered.hasNext() && !found) {
                    Object element = unfiltered.next();
                    if (!predicate.apply(element)) continue;
                    found = true;
                    result = element;
                }
                if (!found) {
                    result = this.endOfData();
                }
                return result;
            }
        };
        return IteratorUtils.toCloseableIterator(i, unfiltered instanceof AutoCloseable ? (AutoCloseable)((Object)unfiltered) : null);
    }

    private IteratorUtils() {
    }
}

