/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.jaxb;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.ArrayUtils;

public class PatternAdapter
extends XmlAdapter<String, Pattern> {
    private static final Pattern EXTRACT_PATTERN = Pattern.compile("^\\/(.*)\\/([imsx]*)$");

    public Pattern unmarshal(String v) throws Exception {
        Pattern pattern;
        if (v != null) {
            Matcher matcher = EXTRACT_PATTERN.matcher(v);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Could not parse: " + v);
            }
            String patternAsString = matcher.group(1);
            String flagsAsString = matcher.group(2);
            pattern = Pattern.compile(patternAsString, this.toFlags(flagsAsString));
        } else {
            pattern = null;
        }
        return pattern;
    }

    public String marshal(Pattern v) throws Exception {
        String patternAsString = v != null ? "/" + v.pattern() + "/" + this.toFlagsAsString(v.flags()) : null;
        return patternAsString;
    }

    @Nonnegative
    protected int toFlags(@Nonnull String flagsAsString) {
        HashSet flagsAsCharacters = Sets.newHashSet((Object[])ArrayUtils.toObject((char[])flagsAsString.toCharArray()));
        int flags = 0;
        if (flagsAsCharacters.contains(Character.valueOf('i'))) {
            flags |= 2;
        }
        if (flagsAsCharacters.contains(Character.valueOf('m'))) {
            flags |= 8;
        }
        if (flagsAsCharacters.contains(Character.valueOf('s'))) {
            flags |= 0x20;
        }
        if (flagsAsCharacters.contains(Character.valueOf('x'))) {
            flags |= 4;
        }
        return flags;
    }

    @Nonnull
    protected String toFlagsAsString(@Nonnegative int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append('i');
        }
        if ((flags & 8) != 0) {
            sb.append('m');
        }
        if ((flags & 0x20) != 0) {
            sb.append('s');
        }
        if ((flags & 4) != 0) {
            sb.append('x');
        }
        return sb.toString();
    }
}

