/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.LogLevels;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jUtils {
    private static final String FQCN = Slf4jUtils.class.getName();
    private static final Map<LogLevel, LogLevel> NORMALIZED_LEVEL_CACHE = new ConcurrentHashMap<LogLevel, LogLevel>();

    public static void log(@Nonnull LocationAwareLogger logger, @Nonnull LogLevel level, @Nullable String fqcn, @Nullable Marker marker, @Nullable String message, @Nullable Object[] argArray, @Nullable Throwable t) {
        if (LogLevel.trace.equals(level)) {
            logger.log(marker, fqcn, 0, message, argArray, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.log(marker, fqcn, 10, message, argArray, t);
        } else if (LogLevel.info.equals(level)) {
            logger.log(marker, fqcn, 20, message, argArray, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.log(marker, fqcn, 30, message, argArray, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.log(marker, fqcn, 40, message, argArray, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), fqcn, marker, message, argArray, t);
        }
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull LogLevel level) {
        boolean result = LogLevel.trace.equals(level) ? logger.isTraceEnabled() : (LogLevel.debug.equals(level) ? logger.isDebugEnabled() : (LogLevel.info.equals(level) ? logger.isInfoEnabled() : (LogLevel.warning.equals(level) ? logger.isWarnEnabled() : (LogLevel.error.equals(level) || LogLevel.fatal.equals(level) ? logger.isErrorEnabled() : Slf4jUtils.isEnabled(logger, Slf4jUtils.normalize(level))))));
        return result;
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nullable String msg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, msg, null, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(msg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(msg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(msg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(msg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(msg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), msg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, @Nullable Object arg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, new Object[]{arg}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, new Object[]{arg1, arg2}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arg1, arg2);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arg1, arg2);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arg1, arg2);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arg1, arg2);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arg1, arg2);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arg1, arg2);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, Object ... arguments) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, arguments, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arguments);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arguments);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arguments);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arguments);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arguments);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arguments);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nullable String msg, @Nullable Throwable t) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, msg, null, t);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(msg, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(msg, t);
        } else if (LogLevel.info.equals(level)) {
            logger.info(msg, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(msg, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(msg, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), msg, t);
        }
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker) {
        boolean result = LogLevel.trace.equals(level) ? logger.isTraceEnabled(marker) : (LogLevel.debug.equals(level) ? logger.isDebugEnabled(marker) : (LogLevel.info.equals(level) ? logger.isInfoEnabled(marker) : (LogLevel.warning.equals(level) ? logger.isWarnEnabled(marker) : (LogLevel.error.equals(level) || LogLevel.fatal.equals(level) ? logger.isErrorEnabled(marker) : Slf4jUtils.isEnabled(logger, Slf4jUtils.normalize(level), marker)))));
        return result;
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nullable String msg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, msg, null, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, msg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, msg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, msg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, msg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, msg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, msg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, @Nullable Object arg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, new Object[]{arg}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, new Object[]{arg1, arg2}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arg1, arg2);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arg1, arg2);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arg1, arg2);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arg1, arg2);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arg1, arg2);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arg1, arg2);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, Object ... arguments) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, arguments, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arguments);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arguments);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arguments);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arguments);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arguments);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arguments);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, msg, null, t);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, msg, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, msg, t);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, msg, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, msg, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, msg, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, msg, t);
        }
    }

    @Nonnull
    protected static LogLevel normalize(@Nonnull LogLevel level) {
        LogLevel result = NORMALIZED_LEVEL_CACHE.get(level);
        if (result == null) {
            result = LogLevel.debug;
            int lastDifference = Slf4jUtils.differenceOf(LogLevel.debug, level);
            for (LogLevel logLevel : LogLevels.allLogLevels()) {
                int difference = Slf4jUtils.differenceOf(logLevel, level);
                if (difference >= lastDifference) continue;
                result = logLevel;
                lastDifference = difference;
            }
            NORMALIZED_LEVEL_CACHE.put(level, result);
        }
        return result;
    }

    @Nonnegative
    protected static int differenceOf(@Nonnull LogLevel a, @Nonnull LogLevel b) {
        int pb;
        int pa = a.getPriority();
        int result = pa == (pb = b.getPriority()) ? 0 : (pa > pb ? pa - pb : pb - pa);
        return result;
    }

    private Slf4jUtils() {
    }
}

