/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.NumberRange;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class IntegerRange
extends NumberRange<Integer> {
    public IntegerRange(@Nullable @Including Integer from, @Nullable @Excluding Integer to) {
        super(from, to);
    }

    @Override
    protected boolean isGreaterThan(@Nonnull Integer what, @Nonnull Integer as) {
        return what > as;
    }

    @Override
    public boolean isSignificant(@Nonnull Integer minValue, @Nonnull Integer maxValue, @Nonnull Integer base) {
        Integer from = (Integer)this.getFrom();
        Integer to = (Integer)this.getTo();
        int range = (to != null ? to : maxValue) - (from != null ? from : minValue);
        return range <= base;
    }

    public static class Adapter
    extends NumberRange.Adapter<Integer, Container, IntegerRange> {
        @Override
        @Nonnull
        protected Container newContainer() {
            return new Container();
        }

        @Override
        @Nonnull
        protected IntegerRange newNumberRange(@Nullable @Including Integer from, @Nullable @Excluding Integer to) {
            return new IntegerRange(from, to);
        }
    }

    @XmlRootElement(name="integerRange")
    @XmlType(name="integerRangeType")
    public static class Container
    extends NumberRange.Container<Integer> {
        @Override
        @XmlAttribute(name="from")
        public Integer getFrom() {
            return (Integer)super.getFrom();
        }

        @Override
        public void setFrom(Integer from) {
            super.setFrom(from);
        }

        @Override
        @XmlAttribute(name="to")
        public Integer getTo() {
            return (Integer)super.getTo();
        }

        @Override
        public void setTo(Integer to) {
            super.setTo(to);
        }
    }
}

