/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.reflection;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;

@NotThreadSafe
public class ClassIterator
implements Iterator<Class<?>> {
    @Nonnull
    private final Deque<Iterator<Class<?>>> _stack = new ArrayDeque();
    @Nullable
    private Class<?> _next;

    @Nonnull
    public static Iterator<Class<?>> classIteratorFor(@Nonnull Class<?> clazz) {
        return new ClassIterator(clazz);
    }

    public ClassIterator(@Nonnull Class<?> startingAt) {
        this._stack.addLast(this.iteratorFor(startingAt));
        this._next = startingAt;
    }

    @Override
    public boolean hasNext() {
        while (this._next == null && !this._stack.isEmpty()) {
            Iterator<Class<?>> childrenIterator = this._stack.getLast();
            if (childrenIterator.hasNext()) {
                this._next = childrenIterator.next();
                this._stack.addLast(this.iteratorFor(this._next));
                continue;
            }
            this._stack.removeLast();
        }
        return this._next != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class<?> next = this._next;
        this._next = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    protected Iterator<Class<?>> iteratorFor(@Nonnull Class<?> what) {
        List<Class<?>> all = CollectionUtils.asList(what.getInterfaces());
        Class<?> superClass = what.getSuperclass();
        if (superClass != null && !what.equals(superClass)) {
            all.add(superClass);
        }
        return CollectionUtils.asImmutableList(all).iterator();
    }
}

