/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.StringUtils;
import org.echocat.jomon.runtime.util.GotInterruptedException;

@XmlJavaTypeAdapter(value=Adapter.class)
@Immutable
@ThreadSafe
public class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final int MAXIMUM_NANOSECONDS_VALUE = 999999;
    @Nonnegative
    private final long _milliSeconds;
    @Nonnegative
    private final int _nanoSeconds;

    public static void sleep(@Nonnull Duration duration) throws InterruptedException {
        duration.sleep();
    }

    public static void sleep(@Nonnull String duration) throws InterruptedException {
        Duration.sleep(new Duration(duration));
    }

    public static void sleep(@Nonnegative long amount, @Nonnull TimeUnit unit) throws InterruptedException {
        Duration.sleep(new Duration(amount, unit));
    }

    public static void sleep(@Nonnegative long milliSeconds) throws InterruptedException {
        Duration.sleep(new Duration(milliSeconds));
    }

    public static void sleep(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) throws InterruptedException {
        Duration.sleep(new Duration(milliSeconds, nanoSeconds));
    }

    public static void sleepSafe(@Nonnull Duration duration) throws GotInterruptedException {
        duration.sleepSafe();
    }

    public static void sleepSafe(@Nonnull String duration) throws GotInterruptedException {
        Duration.sleepSafe(new Duration(duration));
    }

    public static void sleepSafe(@Nonnegative long amount, @Nonnull TimeUnit unit) throws GotInterruptedException {
        Duration.sleepSafe(new Duration(amount, unit));
    }

    public static void sleepSafe(@Nonnegative long milliSeconds) throws GotInterruptedException {
        Duration.sleepSafe(new Duration(milliSeconds));
    }

    public static void sleepSafe(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) throws GotInterruptedException {
        Duration.sleepSafe(new Duration(milliSeconds, nanoSeconds));
    }

    @Nonnull
    public static Duration duration(@Nonnull Duration duration) {
        return duration;
    }

    @Nullable
    public static Duration duration(@Nullable String duration) {
        return duration != null ? new Duration(duration) : null;
    }

    @Nullable
    public static Duration duration(@Nonnegative long milliSeconds) {
        return Duration.duration(milliSeconds, 0);
    }

    @Nullable
    public static Duration duration(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        return new Duration(milliSeconds, nanoSeconds);
    }

    @Nonnull
    public static Duration durationOf(@Nonnull Duration duration) {
        return Duration.duration(duration);
    }

    @Nullable
    public static Duration durationOf(@Nullable String duration) {
        return Duration.duration(duration);
    }

    @Nullable
    public static Duration durationOf(@Nonnegative long duration) {
        return Duration.duration(duration);
    }

    @Nullable
    public static Duration durationOf(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        return Duration.duration(milliSeconds, nanoSeconds);
    }

    public Duration(@Nonnegative long milliSeconds) {
        this(milliSeconds, 0);
    }

    public Duration(@Nonnull String plain) throws IllegalArgumentException {
        this(Duration.parsePattern(plain));
    }

    public Duration(@Nonnegative long duration, @Nonnull TimeUnit unit) {
        this(new MilliAndNanoSeconds(duration, unit));
    }

    public Duration(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        this(new MilliAndNanoSeconds(milliSeconds, nanoSeconds));
    }

    public Duration(@Nonnull Date from, @Nonnull Date to) {
        if (from.after(to)) {
            throw new IllegalArgumentException("From " + from + " is after to " + to + "?");
        }
        this._milliSeconds = to.getTime() - from.getTime();
        this._nanoSeconds = 0;
    }

    protected Duration(@Nonnull MilliAndNanoSeconds seconds) {
        this._milliSeconds = seconds.getMilliSeconds();
        this._nanoSeconds = seconds.getNanoSeconds();
        if (this._milliSeconds < 0L) {
            throw new IllegalArgumentException("MilliSeconds value is negative.");
        }
        if (this._nanoSeconds < 0) {
            throw new IllegalArgumentException("NanoSeconds value is negative.");
        }
        if (this._nanoSeconds > 999999) {
            throw new IllegalArgumentException("NanoSecond value out of range: is " + this._nanoSeconds + "; maximum " + 999999);
        }
    }

    @Nonnull
    public Duration plus(@Nullable Duration duration) {
        long calculatedNanos = this.getNanoSeconds() + duration.getNanoSeconds();
        long additionalMillis = calculatedNanos / 1000000L;
        int nanos = (int)(calculatedNanos - additionalMillis * 1000000L);
        return new Duration(this.getMilliSeconds() + duration.getMilliSeconds() + additionalMillis, nanos);
    }

    @Nonnull
    public Duration plus(@Nullable String duration) {
        return this.plus(duration != null ? new Duration(duration) : null);
    }

    @Nonnull
    public Duration plus(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.plus(new Duration(amount, unit));
    }

    @Nonnull
    public Duration plus(@Nonnegative long milliSeconds) {
        return this.plus(new Duration(milliSeconds));
    }

    @Nonnull
    public Duration minus(@Nullable Duration duration) {
        long calculatedMillis = this.getMilliSeconds() - duration.getMilliSeconds();
        int calculatedNanos = this.getNanoSeconds() - duration.getNanoSeconds();
        int nanos = calculatedNanos >= 0 ? calculatedNanos : 1000000 + calculatedNanos;
        long millis = calculatedMillis - (long)(calculatedNanos >= 0 ? 0 : 1);
        if (millis < 0L) {
            throw new IllegalArgumentException("The result of " + this + " minus " + duration + " is negative.");
        }
        return new Duration(millis, nanos);
    }

    @Nonnull
    public Duration minus(@Nullable String duration) {
        return this.minus(duration != null ? new Duration(duration) : null);
    }

    @Nonnull
    public Duration minus(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.minus(new Duration(amount, unit));
    }

    @Nonnull
    public Duration minus(@Nonnegative long milliSeconds) {
        return this.minus(new Duration(milliSeconds));
    }

    @Nonnull
    public Duration multiplyBy(@Nonnegative double what) {
        if (what < 0.0) {
            throw new IllegalArgumentException();
        }
        double calculatedMillis = (double)this.getMilliSeconds() * what;
        long millis = (long)calculatedMillis;
        long additionalNanos = Math.round((calculatedMillis - (double)millis) * 1000000.0);
        long calculatedNanos = Math.round((double)this.getNanoSeconds() * what) + additionalNanos;
        long additionalMillis = calculatedNanos / 1000000L;
        int nanos = (int)(calculatedNanos - additionalMillis * 1000000L);
        return new Duration(millis + additionalMillis, nanos);
    }

    @Nonnull
    public Duration dividedBy(@Nonnegative double what) {
        if (what < 0.0) {
            throw new IllegalArgumentException();
        }
        double calculatedMillis = (double)this.getMilliSeconds() / what;
        long millis = Math.round(calculatedMillis);
        long additionalNanos = Math.round((calculatedMillis - (double)millis) * 1000000.0);
        long calculatedNanos = Math.round((double)this.getNanoSeconds() / what) + additionalNanos;
        long additionalMillis = calculatedNanos / 1000000L;
        int nanos = (int)(calculatedNanos - additionalMillis * 1000000L);
        return new Duration(millis + additionalMillis, nanos);
    }

    @Nonnull
    public Duration multiplyBy(@Nonnegative long what) {
        if (what < 0L) {
            throw new IllegalArgumentException();
        }
        long millis = this.getMilliSeconds() * what;
        long calculatedNanos = (long)this.getNanoSeconds() * what;
        long additionalMillis = calculatedNanos / 1000000L;
        int nanos = (int)(calculatedNanos - additionalMillis * 1000000L);
        return new Duration(millis + additionalMillis, nanos);
    }

    @Nonnull
    public Duration dividedBy(@Nonnegative long what) {
        if (what < 0L) {
            throw new IllegalArgumentException();
        }
        long millis = this.getMilliSeconds() / what;
        long calculatedNanos = (long)this.getNanoSeconds() / what;
        long additionalMillis = calculatedNanos / 1000000L;
        int nanos = (int)(calculatedNanos - additionalMillis * 1000000L);
        return new Duration(millis + additionalMillis, nanos);
    }

    @Nonnull
    public Duration trim(@Nonnull TimeUnit toUnit) {
        Duration result = toUnit == TimeUnit.NANOSECONDS ? this : (toUnit == TimeUnit.MICROSECONDS ? new Duration(this.getMilliSeconds(), this.getNanoSeconds() / 1000 * 1000) : new Duration(toUnit.toMillis(toUnit.convert(this.getMilliSeconds(), TimeUnit.MILLISECONDS))));
        return result;
    }

    @Nonnegative
    @Deprecated
    public long toMilliSeconds() {
        return this.in(TimeUnit.MILLISECONDS);
    }

    @Nonnegative
    protected long getMilliSeconds() {
        return this._milliSeconds;
    }

    @Nonnegative
    protected int getNanoSeconds() {
        return this._nanoSeconds;
    }

    @Nonnegative
    public long in(@Nonnull TimeUnit unit) {
        long milliSeconds = this.getMilliSeconds();
        int nanoSeconds = this.getNanoSeconds();
        long result = unit != TimeUnit.MICROSECONDS && unit != TimeUnit.NANOSECONDS && milliSeconds > 0L && nanoSeconds > 0 ? unit.convert(milliSeconds * 1000L + (long)nanoSeconds, TimeUnit.NANOSECONDS) : (milliSeconds > 0L ? unit.convert(milliSeconds, TimeUnit.MILLISECONDS) : unit.convert(nanoSeconds, TimeUnit.NANOSECONDS));
        return result;
    }

    @Nonnull
    public String toPattern() {
        return Duration.toPattern(this.getMilliSeconds(), this.getNanoSeconds());
    }

    @Nonnull
    public Map<TimeUnit, Long> toUnitToValue() {
        return Duration.toUnitToValue(this.getMilliSeconds(), this.getNanoSeconds());
    }

    public boolean isEmpty() {
        return this.getMilliSeconds() <= 0L && this.getNanoSeconds() <= 0;
    }

    public boolean hasContent() {
        return this.getMilliSeconds() > 0L || this.getNanoSeconds() > 0;
    }

    public boolean isLessThan(@Nullable String other) {
        return this.isLessThan(other != null ? new Duration(other) : null);
    }

    public boolean isLessThan(@Nullable Duration other) {
        return other != null ? this.isLessThan(other.getMilliSeconds(), other.getNanoSeconds()) : this.isLessThan(0L);
    }

    public boolean isLessThan(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isLessThan(new Duration(amount, unit));
    }

    public boolean isLessThan(@Nonnegative long milliSeconds) {
        return this.isLessThan(milliSeconds, 0);
    }

    protected boolean isLessThan(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        long localMilliSeconds = this.getMilliSeconds();
        return localMilliSeconds < milliSeconds || localMilliSeconds == milliSeconds && this.getNanoSeconds() < nanoSeconds;
    }

    public boolean isLessThanOrEqualTo(@Nullable String other) {
        return this.isLessThanOrEqualTo(other != null ? new Duration(other) : null);
    }

    public boolean isLessThanOrEqualTo(@Nullable Duration other) {
        return other != null ? this.isLessThanOrEqualTo(other.getMilliSeconds(), other.getNanoSeconds()) : this.isLessThanOrEqualTo(0L);
    }

    public boolean isLessThanOrEqualTo(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isLessThanOrEqualTo(new Duration(amount, unit));
    }

    public boolean isLessThanOrEqualTo(@Nonnegative long milliSeconds) {
        return this.isLessThanOrEqualTo(milliSeconds, 0);
    }

    protected boolean isLessThanOrEqualTo(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        long localMilliSeconds = this.getMilliSeconds();
        return localMilliSeconds < milliSeconds || localMilliSeconds == milliSeconds && this.getNanoSeconds() <= nanoSeconds;
    }

    public boolean isGreaterThan(@Nullable String other) {
        return this.isGreaterThan(other != null ? new Duration(other) : null);
    }

    public boolean isGreaterThan(@Nullable Duration other) {
        return other != null ? this.isGreaterThan(other.getMilliSeconds(), other.getNanoSeconds()) : this.isGreaterThan(0L);
    }

    public boolean isGreaterThan(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isGreaterThan(new Duration(amount, unit));
    }

    public boolean isGreaterThan(@Nonnegative long milliSeconds) {
        return this.isGreaterThan(milliSeconds, 0);
    }

    protected boolean isGreaterThan(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        long localMilliSeconds = this.getMilliSeconds();
        return localMilliSeconds > milliSeconds || localMilliSeconds == milliSeconds && this.getNanoSeconds() > nanoSeconds;
    }

    public boolean isGreaterThanOrEqualTo(@Nullable String other) {
        return this.isGreaterThanOrEqualTo(other != null ? new Duration(other) : null);
    }

    public boolean isGreaterThanOrEqualTo(@Nullable Duration other) {
        return other != null ? this.isGreaterThanOrEqualTo(other.getMilliSeconds(), other.getNanoSeconds()) : this.isGreaterThanOrEqualTo(0L);
    }

    public boolean isGreaterThanOrEqualTo(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        return this.isGreaterThanOrEqualTo(new Duration(amount, unit));
    }

    public boolean isGreaterThanOrEqualTo(@Nonnegative long milliSeconds) {
        return this.isGreaterThanOrEqualTo(milliSeconds, 0);
    }

    protected boolean isGreaterThanOrEqualTo(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        long localMilliSeconds = this.getMilliSeconds();
        return localMilliSeconds > milliSeconds || localMilliSeconds == milliSeconds && this.getNanoSeconds() >= nanoSeconds;
    }

    public void sleep() throws InterruptedException {
        Thread.sleep(this.getMilliSeconds(), this.getNanoSeconds());
    }

    public void sleepSafe() throws GotInterruptedException {
        try {
            this.sleep();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GotInterruptedException(e);
        }
    }

    @Override
    public int compareTo(Duration other) {
        int resultOnMilliSeconds = Duration.compare(this.getMilliSeconds(), other != null ? other.getMilliSeconds() : 0L);
        int result = resultOnMilliSeconds == 0 ? Duration.compare(this.getNanoSeconds(), other != null ? (long)other.getNanoSeconds() : 0L) : resultOnMilliSeconds;
        return result;
    }

    private static int compare(@Nonnegative long self, @Nonnegative long other) {
        int result = self < other ? -1 : (self == other ? 0 : 1);
        return result;
    }

    public int hashCode() {
        long milliSeconds = this.getMilliSeconds();
        int nanoSeconds = this.getNanoSeconds();
        return (int)(milliSeconds ^ milliSeconds >>> 32) * nanoSeconds;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o instanceof Duration) {
            Duration other = (Duration)o;
            result = this.getMilliSeconds() == other.getMilliSeconds() && this.getNanoSeconds() == other.getNanoSeconds();
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return this.toPattern();
    }

    @Nonnegative
    protected static long oneUncheckedIntervalToMilliSeconds(@Nonnull String interval) {
        String trimmedInterval = interval.trim();
        return trimmedInterval.isEmpty() ? 0L : Duration.oneIntervalToMilliSeconds(interval);
    }

    @Nonnegative
    protected static long oneUncheckedIntervalToNanoSeconds(@Nonnull String interval) {
        String trimmedInterval = interval.trim();
        return trimmedInterval.isEmpty() ? 0L : Duration.oneIntervalToNanoSeconds(interval);
    }

    @Nonnegative
    protected static long oneIntervalToMilliSeconds(@Nonnull String interval) {
        long value;
        try {
            value = Long.valueOf(interval);
        }
        catch (NumberFormatException ignored) {
            if (interval.length() >= 2) {
                long plainValue;
                try {
                    plainValue = Long.valueOf(interval.substring(0, interval.length() - 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Don't know how to convert: " + interval, e);
                }
                String mode = interval.substring(interval.length() - 1);
                if (mode.equals("S")) {
                    value = plainValue;
                }
                if (mode.equals("s")) {
                    value = TimeUnit.SECONDS.toMillis(plainValue);
                }
                if (mode.equals("m")) {
                    value = TimeUnit.MINUTES.toMillis(plainValue);
                }
                if (mode.equals("h")) {
                    value = TimeUnit.HOURS.toMillis(plainValue);
                }
                if (mode.equals("d")) {
                    value = TimeUnit.DAYS.toMillis(plainValue);
                }
                if (mode.equals("w")) {
                    value = TimeUnit.DAYS.toMillis(plainValue) * 7L;
                }
                throw new IllegalArgumentException("Don't know how to convert: " + interval);
            }
            throw new IllegalArgumentException("Don't know how to convert: " + interval);
        }
        return value;
    }

    @Nonnegative
    protected static long oneIntervalToNanoSeconds(@Nonnull String interval) {
        long value;
        try {
            value = Long.valueOf(interval);
        }
        catch (NumberFormatException ignored) {
            if (interval.length() >= 2) {
                long plainValue;
                try {
                    plainValue = Long.valueOf(interval.substring(0, interval.length() - 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Don't know how to convert: " + interval, e);
                }
                String mode = interval.substring(interval.length() - 1);
                if (mode.equals("n")) {
                    value = plainValue;
                }
                if (mode.equals("\u00c2\u00b5")) {
                    value = TimeUnit.MICROSECONDS.toNanos(plainValue);
                }
                throw new IllegalArgumentException("Don't know how to convert: " + interval);
            }
            throw new IllegalArgumentException("Don't know how to convert: " + interval);
        }
        return value;
    }

    @Nonnegative
    protected static MilliAndNanoSeconds parsePattern(@Nonnull String pattern) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        char[] chars = pattern.replace("ms", "S").replace("\u00c2\u00b5s", "\u00c2\u00b5").replace("ns", "n").toCharArray();
        long milli = 0L;
        long nano = 0L;
        for (char c : chars) {
            if (Character.isWhitespace(c)) {
                milli += Duration.oneUncheckedIntervalToMilliSeconds(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c == 'w' || c == 'd' || c == 'h' || c == 'm' || c == 's' || c == 'S') {
                sb.append(c);
                milli += Duration.oneUncheckedIntervalToMilliSeconds(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (c == '\u00b5' || c == 'n') {
                sb.append(c);
                nano += Duration.oneUncheckedIntervalToNanoSeconds(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            throw new IllegalArgumentException("Don't know how to convert: " + pattern);
        }
        milli += Duration.oneUncheckedIntervalToMilliSeconds(sb.toString());
        long toMuchMillis = nano / 1000000L;
        return new MilliAndNanoSeconds(milli += toMuchMillis, (int)(nano -= toMuchMillis * 1000000L));
    }

    @Nonnull
    protected static String toPattern(@Nonnegative long milliseconds, @Nonnegative int nanoSeconds) {
        StringBuilder sb = new StringBuilder();
        if (milliseconds > 0L) {
            Duration.appendPatternOf(milliseconds, sb);
        }
        if (nanoSeconds > 0) {
            Duration.appendPatternOf(nanoSeconds, sb);
        }
        if (sb.length() == 0) {
            sb.append("0ms");
        }
        return sb.toString();
    }

    protected static void appendPatternOf(@Nonnegative long milliseconds, @Nonnull StringBuilder to) {
        long days = milliseconds / 1000L / 60L / 60L / 24L;
        long hours = milliseconds / 1000L / 60L / 60L - days * 24L;
        long minutes = milliseconds / 1000L / 60L - days * 24L * 60L - hours * 60L;
        long seconds = milliseconds / 1000L - minutes * 60L - hours * 60L * 60L - days * 24L * 60L * 60L;
        long ms = milliseconds - seconds * 1000L - minutes * 60L * 1000L - hours * 1000L * 60L * 60L - days * 24L * 60L * 60L * 1000L;
        if (days > 0L) {
            StringUtils.addElement(to, " ", days + "d");
        }
        if (hours > 0L) {
            StringUtils.addElement(to, " ", hours + "h");
        }
        if (minutes > 0L) {
            StringUtils.addElement(to, " ", minutes + "m");
        }
        if (seconds > 0L) {
            StringUtils.addElement(to, " ", seconds + "s");
        }
        if (ms > 0L) {
            StringUtils.addElement(to, " ", ms + "ms");
        }
    }

    protected static void appendPatternOf(@Nonnegative int nanoSeconds, @Nonnull StringBuilder to) {
        int \u00c2\u00b5s = nanoSeconds / 1000;
        int ns = nanoSeconds - \u00c2\u00b5s * 1000;
        if (\u00c2\u00b5s > 0) {
            StringUtils.addElement(to, " ", \u00c2\u00b5s + "\u00c2\u00b5s");
        }
        if (ns > 0) {
            StringUtils.addElement(to, " ", ns + "ns");
        }
    }

    @Nonnull
    protected static Map<TimeUnit, Long> toUnitToValue(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
        LinkedHashMap<TimeUnit, Long> result = new LinkedHashMap<TimeUnit, Long>();
        Duration.appendUnitToValueOf(milliSeconds, result);
        Duration.appendUnitToValueOf(nanoSeconds, result);
        return Collections.unmodifiableMap(result);
    }

    protected static void appendUnitToValueOf(@Nonnegative long milliSeconds, @Nonnull Map<TimeUnit, Long> to) {
        long days = milliSeconds / 1000L / 60L / 60L / 24L;
        long hours = milliSeconds / 1000L / 60L / 60L - days * 24L;
        long minutes = milliSeconds / 1000L / 60L - days * 24L * 60L - hours * 60L;
        long seconds = milliSeconds / 1000L - minutes * 60L - hours * 60L * 60L - days * 24L * 60L * 60L;
        long ms = milliSeconds - seconds * 1000L - minutes * 60L * 1000L - hours * 1000L * 60L * 60L - days * 24L * 60L * 60L * 1000L;
        if (days > 0L) {
            to.put(TimeUnit.DAYS, days);
        }
        if (hours > 0L) {
            to.put(TimeUnit.HOURS, hours);
        }
        if (minutes > 0L) {
            to.put(TimeUnit.MINUTES, minutes);
        }
        if (seconds > 0L) {
            to.put(TimeUnit.SECONDS, seconds);
        }
        if (ms > 0L) {
            to.put(TimeUnit.MILLISECONDS, ms);
        }
    }

    protected static void appendUnitToValueOf(@Nonnegative int nanoSeconds, @Nonnull Map<TimeUnit, Long> to) {
        long \u00c2\u00b5s = nanoSeconds / 1000;
        long ns = (long)nanoSeconds - \u00c2\u00b5s * 1000L;
        if (\u00c2\u00b5s > 0L) {
            to.put(TimeUnit.MICROSECONDS, \u00c2\u00b5s);
        }
        if (ns > 0L) {
            to.put(TimeUnit.NANOSECONDS, ns);
        }
    }

    public static class Adapter
    extends XmlAdapter<String, Duration> {
        public Duration unmarshal(String v) throws Exception {
            return v != null ? new Duration(v) : null;
        }

        public String marshal(Duration v) throws Exception {
            return v != null ? v.toPattern() : null;
        }
    }

    protected static class MilliAndNanoSeconds {
        @Nonnegative
        private final long _milliSeconds;
        @Nonnegative
        private final int _nanoSeconds;

        public MilliAndNanoSeconds(@Nonnegative long milliSeconds, @Nonnegative int nanoSeconds) {
            this._milliSeconds = milliSeconds;
            this._nanoSeconds = nanoSeconds;
        }

        public MilliAndNanoSeconds(@Nonnegative long duration, @Nonnull TimeUnit unit) {
            if (unit == TimeUnit.NANOSECONDS || unit == TimeUnit.MICROSECONDS) {
                long fullNanoSeconds = unit.toNanos(duration);
                this._milliSeconds = fullNanoSeconds / 1000000L;
                this._nanoSeconds = (int)(fullNanoSeconds - this._milliSeconds * 1000000L);
            } else {
                this._milliSeconds = unit.toMillis(duration);
                this._nanoSeconds = 0;
            }
        }

        @Nonnegative
        public long getMilliSeconds() {
            return this._milliSeconds;
        }

        @Nonnegative
        public int getNanoSeconds() {
            return this._nanoSeconds;
        }
    }
}

