/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.Hint;
import org.echocat.jomon.runtime.util.Key;
import org.echocat.jomon.runtime.util.MutableValueProvider;
import org.echocat.jomon.runtime.util.ValueProvider;
import org.echocat.jomon.runtime.util.ValueProviderUtils;

@NotThreadSafe
public class Hints
extends MutableValueProvider.Base {
    public static final Hints EMPTY_HINTS = Hints.unmodifiableHints(new Hints());
    @Nonnull
    private final Map<Key<Object>, Object> _keyToValue = new HashMap<Key<Object>, Object>();

    @Nonnull
    public static Hints unmodifiableHints(@Nullable Hints hints) {
        return new Hints(hints){

            @Override
            public <T> void set(@Nonnull Hint<T> hint, @Nullable T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> void remove(@Nonnull Hint<T> hint) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Entry<Key<Object>, Object>> iterator() {
                final Iterator<Entry<Key<Object>, Object>> i = super.iterator();
                return new Iterator<Entry<Key<Object>, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Entry<Key<Object>, Object> next() {
                        return (Entry)i.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Nonnull
    public static Hints hints(Object ... parameters) {
        Map<Hint<?>, Object> plainHints = CollectionUtils.asMap(parameters);
        return new Hints(parameters != null ? plainHints : null);
    }

    @Nonnull
    public static Hints nonNullHints(@Nullable Hints hints) {
        return hints != null ? hints : EMPTY_HINTS;
    }

    public Hints() {
    }

    public Hints(@Nullable Hints hints) {
        ValueProviderUtils.setAll((MutableValueProvider)this, hints);
    }

    public Hints(@Nullable Map<Hint<?>, Object> hints) {
        ValueProviderUtils.setAll((MutableValueProvider)this, new Object[]{hints});
    }

    public <T> void set(@Nonnull Hint<T> hint, @Nullable T value) {
        ((MutableValueProvider.Base)this).set(hint, value);
    }

    @Nullable
    public <T> T get(@Nonnull Hint<T> hint) {
        return this.get(hint, hint.getDefaultValue());
    }

    @Nullable
    public <T> T get(@Nonnull Hint<T> hint, @Nullable T defaultValue) {
        return ((ValueProvider.Base)this).get(hint, defaultValue);
    }

    public <T> void remove(@Nonnull Hint<T> hint) {
        ((MutableValueProvider.Base)this).remove(hint);
    }

    @Override
    @Nonnull
    protected Map<Key<Object>, Object> getKeyToValue() {
        return this._keyToValue;
    }

    @Deprecated
    public boolean isEnabled(@Nonnull Hint<Boolean> hint) {
        return ValueProviderUtils.isEnabled(this, hint);
    }

    @Deprecated
    public boolean isEnabled(@Nonnull Hint<Boolean> hint, boolean defaultValue) {
        return ValueProviderUtils.isEnabled(this, hint, defaultValue);
    }

    @Deprecated
    public void setAll(@Nullable Hints hints) {
        ValueProviderUtils.setAll((MutableValueProvider)this, hints);
    }

    @Deprecated
    @Nullable
    public static <T> T get(@Nullable Hints hints, @Nonnull Hint<T> hint) {
        return ValueProviderUtils.get(hints, hint);
    }

    @Deprecated
    @Nullable
    public static <T> T get(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T defaultValue) {
        return ValueProviderUtils.get(hints, hint, defaultValue);
    }

    @Deprecated
    public static boolean isEnabled(@Nullable Hints hints, @Nonnull Hint<Boolean> hint) {
        return ValueProviderUtils.isEnabled(hints, hint);
    }

    @Deprecated
    public static boolean isEnabled(@Nullable Hints hints, @Nonnull Hint<Boolean> hint, boolean defaultValue) {
        return ValueProviderUtils.isEnabled(hints, hint, defaultValue);
    }

    @Deprecated
    public boolean isSet(@Nonnull Hint<?> hint) {
        return this.contains(hint);
    }

    @Deprecated
    public static boolean isSet(@Nullable Hints hints, @Nonnull Hint<?> hint) {
        return ValueProviderUtils.contains(hints, hint);
    }

    @Deprecated
    public <T> boolean is(@Nonnull Hint<T> hint, @Nullable T expected, @Nullable T defaultValue) {
        return ValueProviderUtils.is(this, hint, expected, defaultValue);
    }

    @Deprecated
    public static <T> boolean is(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T expected, @Nullable T defaultValue) {
        return ValueProviderUtils.is(hints, hint, expected, defaultValue);
    }

    @Deprecated
    public <T> boolean is(@Nonnull Hint<T> hint, @Nullable T expected) {
        return ValueProviderUtils.is(this, hint, expected);
    }

    @Deprecated
    public static <T> boolean is(@Nullable Hints hints, @Nonnull Hint<T> hint, @Nullable T expected) {
        return ValueProviderUtils.is(hints, hint, expected);
    }
}

