/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Key<T> {
    @Nonnull
    public Class<T> getValueType();

    @Nonnull
    public String getName();

    @Nullable
    public T getDefaultValue();

    public boolean isNullValueAllowed();

    public static class Impl<T>
    implements Key<T> {
        private final Class<T> _valueType;
        private final String _name;
        private final T _defaultValue;
        private final boolean _nullValueAllowed;

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull String fullName) {
            return Impl.key(valueType, fullName, (Object)null);
        }

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull String fullName, @Nullable T defaultValue) {
            return new Impl<T>(valueType, fullName, defaultValue, true);
        }

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull Class<?> forContainer, @Nonnull String withName) {
            return Impl.key(valueType, forContainer, withName, null);
        }

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull Class<?> forContainer, @Nonnull String withName, @Nullable T defaultValue) {
            return Impl.key(valueType, forContainer.getName() + "." + withName, defaultValue);
        }

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull Object forContainer, @Nonnull String withName) {
            return Impl.key(valueType, forContainer, withName, null);
        }

        @Nonnull
        public static <T> Key<T> key(@Nonnull Class<T> valueType, @Nonnull Object forContainer, @Nonnull String withName, @Nullable T defaultValue) {
            return Impl.key(valueType, forContainer.getClass(), withName, defaultValue);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull String fullName, @Nullable T defaultValue) {
            return new Impl<T>(valueType, fullName, defaultValue, false);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull String fullName) {
            return new Impl<Object>(valueType, fullName, null, false);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull Class<?> forContainer, @Nonnull String withName, @Nonnull T defaultValue) {
            return Impl.nonNullKey(valueType, forContainer.getName() + "." + withName, defaultValue);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull Class<?> forContainer, @Nonnull String withName) {
            return Impl.nonNullKey(valueType, forContainer.getName() + "." + withName);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull Object forContainer, @Nonnull String withName, @Nonnull T defaultValue) {
            return Impl.nonNullKey(valueType, forContainer.getClass(), withName, defaultValue);
        }

        @Nonnull
        public static <T> Key<T> nonNullKey(@Nonnull Class<T> valueType, @Nonnull Object forContainer, @Nonnull String withName) {
            return Impl.nonNullKey(valueType, forContainer.getClass(), withName);
        }

        public Impl(@Nonnull Class<T> valueType, @Nonnull String name, @Nullable T defaultValue, boolean nullValueAllowed) {
            this._valueType = valueType;
            this._name = name;
            this._defaultValue = defaultValue;
            this._nullValueAllowed = nullValueAllowed;
        }

        @Override
        @Nonnull
        public Class<T> getValueType() {
            return this._valueType;
        }

        @Override
        @Nonnull
        public String getName() {
            return this._name;
        }

        @Override
        public T getDefaultValue() {
            return this._defaultValue;
        }

        @Override
        public boolean isNullValueAllowed() {
            return this._nullValueAllowed;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            boolean result = this == o ? true : (!(o instanceof Key) ? false : this.getName().equals(((Key)o).getName()));
            return result;
        }

        public int hashCode() {
            return this._name.hashCode();
        }
    }
}

