/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.ValueHolder;

public class ValueUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static <T> T findValue(@Nullable Object plain, @Nonnull Class<T> valueType, @Nullable T defaultValue) {
        T result;
        if (plain == null) {
            result = null;
            return result != null ? result : (T)defaultValue;
        } else if (valueType.isInstance(plain)) {
            result = valueType.cast(plain);
            return result != null ? result : (T)defaultValue;
        } else {
            if (!(plain instanceof ValueHolder)) throw new IllegalArgumentException("The provided value " + plain + " is neither an instance of expected value type " + valueType.getName() + " nor " + ValueHolder.class.getName() + ".");
            ValueHolder holder = (ValueHolder)plain;
            if (!valueType.isAssignableFrom(holder.providesValueOfType())) throw new IllegalArgumentException(holder + " provides value of " + holder.providesValueOfType().getName() + " which is not assignable from expected type " + valueType.getName() + ".");
            result = valueType.cast(holder.getValue());
        }
        return result != null ? result : (T)defaultValue;
    }

    @Nullable
    public static <T> T findValue(@Nullable Object plain, @Nonnull Class<T> valueType) {
        return ValueUtils.findValue(plain, valueType, null);
    }

    @Nonnull
    public static <T> T getValue(@Nullable Object plain, @Nonnull Class<T> valueType, @Nonnull T defaultValue) {
        return ValueUtils.findValue(plain, valueType, defaultValue);
    }

    @Nonnull
    public static <T> T getValue(@Nonnull Object plain, @Nonnull Class<T> valueType) {
        T result = ValueUtils.findValue(plain, valueType);
        if (result == null) {
            if (plain instanceof ValueHolder) {
                throw new NullPointerException(plain + " returned null.");
            }
            throw new NullPointerException("Given object is null.");
        }
        return result;
    }

    private ValueUtils() {
    }
}

