/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.echocat.jomon.net.cluster.channel.HandlerEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Node;
import org.echocat.jomon.net.cluster.channel.PingEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.echocat.jomon.net.cluster.channel.StatisticEnabledClusterChannel;
import org.echocat.jomon.runtime.math.OverPeriodCounter;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetBasedClusterChannel<ID, N extends Node<ID>>
implements StatisticEnabledClusterChannel<ID, N>,
PingEnabledClusterChannel<ID, N>,
HandlerEnabledClusterChannel<ID, N> {
    private static final Logger LOG = LoggerFactory.getLogger(NetBasedClusterChannel.class);
    private final Collection<HandlerEnabledClusterChannel.Handler> _handlers = new ArrayList<HandlerEnabledClusterChannel.Handler>();
    private final Lock _lock = new ReentrantLock();
    private final UUID _uuid;
    private volatile String _name;
    private Duration _soTimeout = new Duration("30s");
    private Duration _pingInterval = new Duration("10s");
    private volatile long _lastPingSend;
    private final OverPeriodCounter _messagesReceivedPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
    private volatile long _messagesReceived;
    private volatile long _lastMessageReceived;
    private final OverPeriodCounter _messagesSendPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
    private volatile long _messagesSend;
    private volatile long _lastMessageSend;

    protected NetBasedClusterChannel() {
        this(null);
    }

    protected NetBasedClusterChannel(@Nullable UUID uuid) {
        this._uuid = uuid != null ? uuid : UUID.randomUUID();
    }

    @Override
    @Nonnull
    public final UUID getUuid() {
        return this._uuid;
    }

    @Override
    @Nullable
    public final String getName() {
        return this._name;
    }

    @Override
    public void setName(final @Nullable String name) {
        this.doSafeAndReinetIfNeeded(new Callable<Void>(){

            @Override
            public Void call() {
                NetBasedClusterChannel.this._name = name;
                return null;
            }
        });
    }

    @Nonnull
    public final Duration getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(@Nonnull Duration soTimeout) {
        if (soTimeout == null) {
            throw new NullPointerException();
        }
        this._soTimeout = soTimeout;
    }

    @Override
    @Nonnull
    public final Duration getPingInterval() {
        return this._pingInterval;
    }

    @Override
    public void setPingInterval(@Nonnull Duration pingInterval) {
        if (pingInterval == null) {
            throw new NullPointerException();
        }
        this._pingInterval = pingInterval;
    }

    protected final void reInitIfNeeded() {
        if (this.isConnected()) {
            ResourceUtils.closeQuietly((AutoCloseable)this);
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not reinitialize " + this + ".", e);
            }
        }
    }

    /*
     * Loose catch block
     */
    protected final <T> T doSafeAndReinetIfNeeded(@Nonnull Callable<T> by) {
        this._lock.lock();
        try {
            T t;
            try {
                t = by.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute set.", e);
            }
            finally {
                this.reInitIfNeeded();
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    protected final <T> T doSafe(@Nonnull Callable<T> by) {
        this._lock.lock();
        try {
            T t = by.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute set.", e);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public final void init() throws Exception {
        this.initBeforeLock();
        this._lock.lock();
        try {
            boolean success = false;
            try {
                this.initInLock();
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }
        finally {
            this._lock.unlock();
        }
        this.initAfterLock();
    }

    protected void initBeforeLock() throws Exception {
    }

    protected void initInLock() throws Exception {
    }

    protected void initAfterLock() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public final void close() throws Exception {
        this.closeBeforeLock();
        this._lock.lock();
        try {
            this.closeInLock();
        }
        finally {
            try {
                this._lock.unlock();
            }
            finally {
                this.closeAfterLock();
            }
        }
    }

    protected void closeBeforeLock() throws Exception {
    }

    protected void closeInLock() throws Exception {
    }

    protected void closeAfterLock() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void register(@Nonnull HandlerEnabledClusterChannel.Handler handler) {
        Collection<HandlerEnabledClusterChannel.Handler> collection = this._handlers;
        synchronized (collection) {
            if (!this._handlers.contains(handler)) {
                this._handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unregister(@Nonnull HandlerEnabledClusterChannel.Handler handler) {
        Collection<HandlerEnabledClusterChannel.Handler> collection = this._handlers;
        synchronized (collection) {
            this._handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected final Collection<HandlerEnabledClusterChannel.Handler> getHandlers() {
        Collection<HandlerEnabledClusterChannel.Handler> collection = this._handlers;
        synchronized (collection) {
            return new ArrayList<HandlerEnabledClusterChannel.Handler>(this._handlers);
        }
    }

    protected void recordMessageSend() {
        this._messagesSendPerSecond.record();
        ++this._messagesSend;
        this._lastMessageSend = System.currentTimeMillis();
    }

    protected void recordReceived() {
        this._messagesReceivedPerSecond.record();
        ++this._messagesReceived;
        this._lastMessageReceived = System.currentTimeMillis();
    }

    protected final void recordPingSend() {
        this._lastPingSend = System.currentTimeMillis();
    }

    @Override
    @Nonnull
    public final Date getLastPingSendAt() {
        return new Date(this._lastPingSend);
    }

    @Override
    public final Date getLastMessageReceived() {
        long lastMessageReceived = this._lastMessageReceived;
        return lastMessageReceived > 0L ? new Date(lastMessageReceived) : null;
    }

    @Override
    @Nonnegative
    @Nonnull
    public final Double getMessagesReceivedPerSecond() {
        return this._messagesReceivedPerSecond.getAsDouble();
    }

    @Override
    @Nonnegative
    @Nonnull
    public final Long getMessagesReceived() {
        return this._messagesReceived;
    }

    @Override
    public final Date getLastMessageSend() {
        long lastMessageSend = this._lastMessageSend;
        return lastMessageSend > 0L ? new Date(lastMessageSend) : null;
    }

    @Override
    @Nonnegative
    @Nonnull
    public final Double getMessagesSendPerSecond() {
        return this._messagesSendPerSecond.getAsDouble();
    }

    @Override
    @Nonnegative
    @Nonnull
    public final Long getMessagesSend() {
        return this._messagesSend;
    }

    protected final void read(@Nonnull ReceivedMessage<N> message) throws IOException {
        this.recordReceived();
        if (message.getCommand() == -128) {
            this.readPing(message);
        } else {
            for (HandlerEnabledClusterChannel.Handler handler : this.getHandlers()) {
                if (!(handler instanceof HandlerEnabledClusterChannel.MessageHandler)) continue;
                ((HandlerEnabledClusterChannel.MessageHandler)handler).handle(this, message);
            }
        }
    }

    protected abstract void readPing(@Nonnull ReceivedMessage<N> var1);

    protected boolean isPingRequired() {
        return this._lastPingSend + this._pingInterval.toMilliSeconds() < System.currentTimeMillis();
    }

    @Nonnull
    public Lock getLock() {
        return this._lock;
    }

    protected class Pinger
    implements Runnable {
        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        NetBasedClusterChannel.this.ping();
                    }
                    catch (Exception e) {
                        LOG.warn("Ping failed. Ping will be retried in " + NetBasedClusterChannel.this._pingInterval + ".", (Throwable)e);
                    }
                    NetBasedClusterChannel.this._pingInterval.sleep();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

