/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.ByteUtils;
import org.echocat.jomon.net.cluster.channel.ReceivedMessage;
import org.echocat.jomon.net.cluster.channel.tcp.InboundTcpNode;
import org.echocat.jomon.net.cluster.channel.tcp.TcpClusterChannel;
import org.echocat.jomon.net.cluster.channel.tcp.TcpNode;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundTcpWorker
extends Thread
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpClusterChannel.class);
    private final InboundTcpNode _node;
    private final InputStream _is;
    private final Reader _reader;

    public InboundTcpWorker(@Nonnull Reader reader, @Nonnull Socket socket, @Nonnull UUID serverUuid, @Nonnull String service, @Nullable String name) throws IOException {
        this.setName("InboundTcp(" + service + "/" + (name != null ? name : serverUuid) + ")<(resolving)");
        this.setDaemon(true);
        this._reader = reader;
        OutputStream os = socket.getOutputStream();
        this.sendInit(os, serverUuid);
        this._is = socket.getInputStream();
        this._node = this.readNode(socket, this._is);
        this.setName("InboundTcp(" + service + "/" + (name != null ? name : serverUuid) + ")<(" + this._node.getAddress() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!InboundTcpWorker.currentThread().isInterrupted() && this._node.isConnected()) {
                byte command = this.readCommand();
                byte[] messageData = this.readMessageData(this._is);
                ReceivedMessage<TcpNode> message = new ReceivedMessage<TcpNode>(command, messageData, this._node);
                this._reader.read(message);
                this._node.recordInbound();
            }
        }
        catch (InterruptedIOException ignored) {
            InboundTcpWorker.currentThread().interrupt();
        }
        catch (EOFException ignored) {
        }
        catch (Exception e) {
            if (!(e instanceof IOException) || this._node.isConnected()) {
                LOG.warn("Got unexpected error while handling connection from " + this._node.getAddress() + ". Close this connection now.", (Throwable)e);
            }
        }
        finally {
            ResourceUtils.closeQuietly((AutoCloseable)this);
        }
    }

    private byte readCommand() throws IOException {
        byte[] command = new byte[1];
        if (this._is.read(command) < 1) {
            throw new EOFException();
        }
        return command[0];
    }

    protected void sendInit(@Nonnull OutputStream to, @Nonnull UUID serverUuid) throws IOException {
        byte[] uuidAsBytes = new byte[16];
        ByteUtils.putLong(uuidAsBytes, 0, serverUuid.getMostSignificantBits());
        ByteUtils.putLong(uuidAsBytes, 8, serverUuid.getLeastSignificantBits());
        to.write(uuidAsBytes);
    }

    @Nonnull
    protected InboundTcpNode readNode(@Nonnull Socket socket, @Nonnull InputStream is) throws IOException {
        UUID uuid = this.readUuid(is);
        return new InboundTcpNode(uuid, socket, is);
    }

    @Nonnull
    protected UUID readUuid(@Nonnull InputStream is) throws IOException {
        byte[] buf = new byte[16];
        int read = is.read(buf);
        if (read != 16) {
            throw new IOException("Received a content that is not 16 bytes long.");
        }
        return new UUID(ByteUtils.getLong(buf, 0), ByteUtils.getLong(buf, 8));
    }

    @Nonnull
    protected byte[] readMessageData(@Nonnull InputStream is) throws IOException {
        int length = this.readLengthFrom(is);
        byte[] messageData = new byte[length];
        int offset = 0;
        int read = is.read(messageData);
        while (read >= 0 && offset < length) {
            read = is.read(messageData, offset += read, length - offset);
        }
        if (read < 0) {
            throw new EOFException();
        }
        if (offset != length) {
            throw new IOException("Received a payload with another payload length then expected.");
        }
        return messageData;
    }

    protected int readLengthFrom(@Nonnull InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        if (is.read(bytes) < 0) {
            throw new EOFException();
        }
        int length = ByteUtils.getInt(bytes, 0);
        if (length < 0) {
            throw new IOException("Received illegal packet. Leading packet is not the length of the following content.");
        }
        return length;
    }

    @Nonnull
    public InboundTcpNode getNode() {
        return this._node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            this._node.close();
        }
        finally {
            this._reader.onClose(this);
        }
    }

    @Override
    public String toString() {
        return this._node.toString();
    }

    public static interface Reader {
        public void read(@Nonnull ReceivedMessage<TcpNode> var1) throws IOException;

        public void onClose(@Nonnull InboundTcpWorker var1) throws Exception;
    }
}

