/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.net.Protocol;
import org.echocat.jomon.net.cluster.channel.ByteUtils;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.net.service.SrvEntryBasedServicesManager;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.runtime.util.ServiceTemporaryUnavailableException;

@ThreadSafe
public class TcpInput
extends SrvEntryBasedServicesManager<InetSocketAddress, OutputStream> {
    private final UUID _uuid;
    private Duration _connectionTimeout = new Duration("2s");
    private Duration _soTimeout = new Duration("30s");

    public TcpInput(@Nonnull String service, @Nonnull UUID uuid) {
        super(Protocol.tcp, service);
        this._uuid = uuid;
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(@Nonnull Duration connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    @Nonnull
    public Duration getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(@Nonnull Duration soTimeout) {
        this._soTimeout = soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream tryGetOutputFor(@Nonnull InetSocketAddress original, @Nonnull InetSocketAddress target, @Nonnull SrvEntryBasedServicesManager.State oldState) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.setReuseAddress(true);
        socket.setSoTimeout((int)this._soTimeout.toMilliSeconds());
        socket.connect(target, (int)this._connectionTimeout.toMilliSeconds());
        boolean success = false;
        try {
            OutputStream os = socket.getOutputStream();
            try {
                this.sendPing(os);
                success = true;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                os = null;
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly((AutoCloseable)os);
                }
            }
            OutputStream outputStream = os;
            return outputStream;
        }
        finally {
            if (!success) {
                ResourceUtils.closeQuietly((AutoCloseable)socket);
            }
        }
    }

    public void send(@Nonnull Message message) throws Exception, InterruptedException {
        for (Object output : this.getOutputs()) {
            this.send(message, (OutputStream)output);
        }
    }

    public void sendPing() throws Exception {
        try {
            this.send(this.createPingMessage());
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(@Nonnull Message message, @Nonnull OutputStream to) throws Exception, InterruptedException {
        boolean success = false;
        boolean errorHandled = false;
        try {
            this.sendUnsafe(message, to);
            success = true;
        }
        catch (ServiceTemporaryUnavailableException e) {
            this.markAsGone(to, e.getMessage());
            errorHandled = true;
        }
        finally {
            if (!success && !errorHandled) {
                this.markAsGone(to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUnsafe(@Nonnull Message message, @Nonnull OutputStream to) throws Exception {
        OutputStream outputStream = to;
        synchronized (outputStream) {
            to.write(message.getCommand());
            to.write(message.getData(), message.getOffset(), message.getLength());
        }
    }

    protected void sendPing(@Nonnull OutputStream to) throws Exception, InterruptedException {
        this.send(this.createPingMessage(), to);
    }

    @Nonnull
    protected Message createPingMessage() {
        byte[] payload = new byte[16];
        ByteUtils.putLong(payload, 0, this._uuid.getMostSignificantBits());
        ByteUtils.putLong(payload, 8, this._uuid.getLeastSignificantBits());
        return new Message(-128, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsGone(@Nonnull OutputStream service, @Nullable String cause) throws InterruptedException {
        try {
            super.markAsGone((Object)service, cause);
        }
        finally {
            ResourceUtils.closeQuietly((AutoCloseable)service);
        }
    }

    protected InetSocketAddress toInetSocketAddress(@Nonnull InetSocketAddress input) throws Exception {
        return input;
    }
}

