/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.environments;

import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.Log4JUtils;
import org.echocat.jomon.runtime.reflection.ClassUtils;
import org.echocat.jomon.testing.environments.BaseEnvironment;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEnvironment
extends BaseEnvironment
implements TestRule {
    private final Class<?> _reference;

    public LogEnvironment() {
        this(null);
    }

    public LogEnvironment(@Nonnull Object object) {
        this(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public LogEnvironment(@Nullable Class<?> clazz) {
        Class<?> targetClass = clazz != null ? clazz : this.findTopFromCallStack();
        String configuration = this.findFileFor(targetClass, this.getLog4JFileNameSuffixOfClasses(), this.getLog4JConfigurationFileNameInPackage());
        if (configuration == null) {
            configuration = this.findFileFor(LogEnvironment.class, this.getLog4JFileNameSuffixOfClasses(), this.getLog4JConfigurationFileNameInPackage());
        }
        if (configuration != null) {
            Log4JUtils.configureRuntime((URL)targetClass.getClassLoader().getResource(configuration));
        }
        this._reference = targetClass;
    }

    @Override
    public void close() {
    }

    @Nonnull
    protected String getLog4JFileNameSuffixOfClasses() {
        return ".log4j.xml";
    }

    @Nonnull
    protected String getLog4JConfigurationFileNameInPackage() {
        return "log4j.xml";
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }

    @Nonnull
    public Logger getLogger() {
        return this.getLogger(this._reference);
    }

    @Nonnull
    public Logger getLogger(@Nonnull String name) {
        return LoggerFactory.getLogger((String)name);
    }

    @Nonnull
    public Logger getLogger(@Nonnull Class<?> reference) {
        return LoggerFactory.getLogger(reference);
    }

    @Nonnull
    protected Class<?> findTopFromCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Class found = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            Class currentClass = ClassUtils.findClass((String)stackTraceElement.getClassName());
            if (currentClass == Thread.class || currentClass.isAssignableFrom(LogEnvironment.class)) continue;
            found = currentClass;
            break;
        }
        return found != null ? found : this.getClass();
    }
}

