/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.format.Format;
import org.echocat.jomon.format.FormatProviderSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.echocat.jomon.runtime.util.Hints;

public class BasicFormatProvider
extends FormatProviderSupport {
    public static final Map<String, Source.Format> NAME_TO_SOURCE_FORMAT = BasicFormatProvider.readFormatsOf(Source.Format.class);
    public static final Map<String, Target.Format> NAME_TO_TARGET_FORMAT = BasicFormatProvider.readFormatsOf(Target.Format.class);

    @Nonnull
    public static <F extends Format> Map<String, F> readFormatsOf(@Nonnull Class<F> formatType) {
        LinkedHashMap<String, Format> result = new LinkedHashMap<String, Format>();
        for (Field field : formatType.getDeclaredFields()) {
            Format format;
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !formatType.isAssignableFrom(field.getType())) continue;
            try {
                format = (Format)formatType.cast(field.get(null));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read value of " + field + ".", e);
            }
            result.put(format.getName(), format);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Source.Format findSourceFormatBy(@Nonnull String name, @Nullable Hints hints) {
        return NAME_TO_SOURCE_FORMAT.get(name);
    }

    @Override
    public Target.Format findTargetFormatBy(@Nonnull String name, @Nullable Hints hints) {
        return NAME_TO_TARGET_FORMAT.get(name);
    }
}

