/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.CollectionUtils;

public class ExecutableDiscovery {
    @Nonnull
    private static final ExecutableDiscovery INSTANCE = new ExecutableDiscovery();

    @Nonnull
    public static ExecutableDiscovery getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static ExecutableDiscovery executableDiscovery() {
        return ExecutableDiscovery.getInstance();
    }

    @Nullable
    public File discover(@Nonnull Task task) {
        File result = this.findFullQualifiedExecutableOf(task);
        if (result == null) {
            List<File> searchInPaths = this.getSearchInPathsFor(task);
            result = this.discoverIn(task, searchInPaths);
        }
        return result;
    }

    @Nullable
    protected File findFullQualifiedExecutableOf(@Nonnull Task task) {
        return this.findFullQualifiedExecutableOf(task.getExecutableNames());
    }

    @Nullable
    protected File findFullQualifiedExecutableOf(@Nonnull Iterable<String> executableNames) {
        File result = null;
        for (String executableName : executableNames) {
            File potentialExecutable = new File(executableName);
            if (!potentialExecutable.isAbsolute() || !potentialExecutable.canExecute()) continue;
            result = potentialExecutable;
            break;
        }
        return result;
    }

    @Nonnull
    protected List<File> getSearchInPathsFor(@Nonnull Task task) {
        ArrayList<File> result = new ArrayList<File>();
        for (String environmentVariable : task.getEnvironmentVariables()) {
            result.addAll(this.getSearchInPathsFor(task, environmentVariable));
        }
        result.addAll(this.getBaseSearchInPathsFor("PATH"));
        return result;
    }

    @Nonnull
    protected List<File> getSearchInPathsFor(@Nonnull Task task, @Nonnull String environmentVariable) {
        List<File> bases = this.getBaseSearchInPathsFor(environmentVariable);
        ArrayList<File> result = new ArrayList<File>(bases.size());
        for (File base : bases) {
            List<String> subDirectories = task.getSubDirectories();
            if (subDirectories.isEmpty()) {
                result.add(base);
                continue;
            }
            for (String subDirectory : subDirectories) {
                result.add(new File(base, subDirectory));
            }
        }
        return result;
    }

    @Nonnull
    protected List<File> getBaseSearchInPathsFor(@Nonnull String environmentVariable) {
        String plainPaths = System.getenv(environmentVariable);
        String[] paths = plainPaths != null ? StringUtils.split((String)plainPaths, (char)File.pathSeparatorChar) : null;
        ArrayList<File> result = new ArrayList<File>(paths != null ? paths.length : 0);
        if (paths != null) {
            for (String path : paths) {
                result.add(new File(path));
            }
        }
        return result;
    }

    @Nullable
    protected File discoverIn(@Nonnull Task task, @Nonnull List<File> searchInPaths) {
        File searchInPath;
        File result = null;
        Iterator<File> i$ = searchInPaths.iterator();
        while (i$.hasNext() && (result = this.discoverIn(task, searchInPath = i$.next())) == null) {
        }
        return result;
    }

    @Nullable
    protected File discoverIn(@Nonnull Task task, @Nonnull File searchInPath) {
        String executableName;
        File result = null;
        List<String> executableNames = task.getExecutableNames();
        Iterator<String> i$ = executableNames.iterator();
        while (i$.hasNext() && (result = this.discoverIn(task, searchInPath, executableName = i$.next())) == null) {
        }
        return result;
    }

    @Nullable
    protected File discoverIn(@Nonnull Task task, @Nonnull File searchInPath, @Nonnull String executableName) {
        String extension;
        File result = null;
        Iterator<String> i$ = FileSystem.currentFileSystem().getExecutableExtensions().iterator();
        while (i$.hasNext() && (result = this.discoverIn(task, searchInPath, executableName, extension = i$.next())) == null) {
        }
        return result;
    }

    @Nullable
    protected File discoverIn(@Nonnull Task task, @Nonnull File searhInPath, @Nonnull String executableName, @Nonnull String extension) {
        File potentialFile = new File(searhInPath, executableName + extension);
        return potentialFile.canExecute() ? potentialFile : null;
    }

    public static enum FileSystem {
        windowsBased(false, ".exe", ".cmd", ".bat", ".pif"),
        linuxBased(true, "", ".sh"),
        macosxBased(true, "", ".sh");

        private static final FileSystem CURRENT_FILE_SYSTEM;
        @Nonnull
        private final List<String> _executableExtensions;
        private final boolean _caseSensitive;

        @Nonnull
        private static FileSystem discoverCurrentFileSystem() {
            FileSystem result;
            String osName = System.getProperty("os.name", "unknown").toLowerCase();
            if (osName.contains("windows")) {
                result = windowsBased;
            } else if (osName.contains("linux")) {
                result = linuxBased;
            } else if (osName.contains("mac") || osName.contains("darwin")) {
                result = macosxBased;
            } else {
                throw new IllegalStateException("This JVM does not run on an supported operating system, for operating with chromedriver.");
            }
            return result;
        }

        private FileSystem(boolean caseSensitive, String ... executableExtensions) {
            this._caseSensitive = caseSensitive;
            ArrayList<String> targetExtensions = new ArrayList<String>(executableExtensions.length);
            for (String extension : executableExtensions) {
                targetExtensions.add(caseSensitive ? extension : extension.toUpperCase());
            }
            this._executableExtensions = CollectionUtils.asImmutableList(targetExtensions);
        }

        @Nonnull
        public List<String> getExecutableExtensions() {
            return this._executableExtensions;
        }

        public boolean hasExecutableExtension(@Nonnull String extension) {
            return this._executableExtensions.contains(this._caseSensitive ? extension : extension.toUpperCase());
        }

        @Nonnull
        public static FileSystem currentFileSystem() {
            return CURRENT_FILE_SYSTEM;
        }

        static {
            CURRENT_FILE_SYSTEM = FileSystem.discoverCurrentFileSystem();
        }
    }

    public static class Task {
        @Nonnull
        private final List<String> _executableNames = new ArrayList<String>(1);
        @Nonnull
        private final List<String> _environmentVariables = new ArrayList<String>();
        @Nonnull
        private final List<String> _subDirectories = new ArrayList<String>();
        private boolean _autoDetectExtensions = true;

        @Nonnull
        public static Task executableDiscoveryTask(String ... executableNames) {
            return new Task().withExecutableNames(executableNames);
        }

        @Nonnull
        public static Task executable(String ... executableNames) {
            return Task.executableDiscoveryTask(executableNames);
        }

        @Nonnull
        public static Task executableDiscoveryTask(@Nonnull Iterable<String> executableNames) {
            return new Task().withExecutableNames(executableNames);
        }

        @Nonnull
        public static Task executable(@Nonnull Iterable<String> executableNames) {
            return Task.executableDiscoveryTask(executableNames);
        }

        @Nonnull
        public Task withExecutableNames(String ... names) {
            if (names == null || names.length <= 0 || names[0] == null) {
                throw new IllegalArgumentException("There is a minimum of 1 name required.");
            }
            CollectionUtils.addAll(this._executableNames, (Object[])names);
            return this;
        }

        @Nonnull
        public Task withExecutableNames(@Nonnull Iterable<String> names) {
            if (names == null) {
                throw new IllegalArgumentException("There is a minimum of 1 name required.");
            }
            Iterator<String> iterator = names.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("There is a minimum of 1 name required.");
            }
            CollectionUtils.addAll(this._executableNames, iterator);
            return this;
        }

        @Nonnull
        public Task withExecutableName(@Nonnull String name) {
            return this.withExecutableNames(name);
        }

        @Nonnull
        public Task withinEnvironmentVariables(String ... names) {
            CollectionUtils.addAll(this._environmentVariables, (Object[])names);
            return this;
        }

        @Nonnull
        public Task withinEnvironmentVariables(@Nullable Iterable<String> names) {
            CollectionUtils.addAll(this._environmentVariables, names);
            return this;
        }

        @Nonnull
        public Task withinEnvironmentVariable(@Nullable String name) {
            if (name != null) {
                this._environmentVariables.add(name);
            }
            return this;
        }

        @Nonnull
        public Task searchInSubDirectories(String ... paths) {
            CollectionUtils.addAll(this._subDirectories, (Object[])paths);
            return this;
        }

        @Nonnull
        public Task searchInSubDirectories(@Nullable Iterable<String> paths) {
            CollectionUtils.addAll(this._subDirectories, paths);
            return this;
        }

        @Nonnull
        public Task searchInSubDirectory(@Nullable String path) {
            if (path != null) {
                this._subDirectories.add(path);
            }
            return this;
        }

        @Nonnull
        public Task autoDetectExtensions(boolean autoDetectExtensions) {
            this._autoDetectExtensions = autoDetectExtensions;
            return this;
        }

        @Nonnull
        public Task autoDetectExtensions() {
            return this.autoDetectExtensions(true);
        }

        @Nonnull
        public Task doNotAutoDetectExtensions() {
            return this.autoDetectExtensions(false);
        }

        @Nonnull
        public List<String> getExecutableNames() {
            return this._executableNames;
        }

        @Nonnull
        public List<String> getEnvironmentVariables() {
            return this._environmentVariables;
        }

        @Nonnull
        public List<String> getSubDirectories() {
            return this._subDirectories;
        }

        public boolean isAutoDetectExtensions() {
            return this._autoDetectExtensions;
        }
    }
}

