/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.OutputMonitor;
import org.echocat.jomon.process.daemon.ProcessDaemonRequirement;
import org.echocat.jomon.process.daemon.ProcessMonitor;
import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.concurrent.ThreadUtils;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.ByteCount;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessDaemon<E, ID, P extends GeneratedProcess<E, ID>, R extends ProcessDaemonRequirement<E, ID, P, ?>, DEB>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDaemon.class);
    @Nonnull
    public static final ByteCount DEFAULT_SIZE_OF_READ_BUFFER = ByteCount.byteCountOf((String)"1k");
    @Nonnull
    private final R _requirement;
    @Nonnull
    private final P _process;
    @Nonnull
    private final List<Thread> _monitors;

    protected ProcessDaemon(@Nonnull DEB dependencies, @Nonnull R requirement) throws CouldNotStartException {
        this._requirement = requirement;
        try {
            this._process = this.generateProcess(dependencies, requirement);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create process.", e);
        }
        boolean success = false;
        try {
            requirement.getStartupListener().notifyProcessStarted(this._process);
            requirement.getStreamListener().notifyProcessStarted(this._process);
            this._monitors = CollectionUtils.asImmutableList((Object[])new Thread[]{this.createOutputMonitorThreadFor(requirement, this._process, this._process.getStderr(), StreamType.stderr), this.createOutputMonitorThreadFor(requirement, this._process, this._process.getStdout(), StreamType.stdout), this.createProcessMonitorThreadFor(requirement, this._process)});
            for (Thread monitor : this._monitors) {
                monitor.start();
            }
            this.waitForStart(requirement);
            success = true;
            requirement.getStartupListener().notifyProcessStartupDone(this._process);
            requirement.getStreamListener().notifyProcessStartupDone(this._process);
        }
        catch (IOException e) {
            throw new CouldNotStartException("Could not control the process " + this._process + ".", e);
        }
        finally {
            if (!success) {
                this.shutdownImmediatelyAfterStart(requirement);
            }
        }
    }

    @Nonnull
    protected Thread createOutputMonitorThreadFor(@Nonnull R requirement, @Nonnull P process, @Nonnull InputStream is, @Nonnull StreamType streamType) {
        OutputMonitor<E, ID, P, R> monitor = this.createOutputMonitorFor(requirement, process, is, streamType);
        return new Thread(monitor, streamType + ":" + process.getId());
    }

    @Nonnull
    protected OutputMonitor<E, ID, P, R> createOutputMonitorFor(@Nonnull R requirement, @Nonnull P process, @Nonnull InputStream is, @Nonnull StreamType streamType) {
        return new OutputMonitor(requirement, process, is, streamType, this.getSizeOfReadBuffer());
    }

    @Nonnull
    protected Thread createProcessMonitorThreadFor(@Nonnull R requirement, @Nonnull P process) {
        ProcessMonitor monitor = new ProcessMonitor(requirement, process);
        Object id = process.getId();
        return new Thread(monitor, "Process:" + (id != null ? id.toString() : "<unknown>"));
    }

    protected void waitForStart(@Nonnull R requirement) {
        try {
            StartupListener startupListener = requirement.getStartupListener();
            if (!startupListener.waitForSuccessfulStart()) {
                Throwable e = startupListener.getStartupProblem();
                if (e == null) {
                    e = new CouldNotStartException("Could not successful start process. Output while waiting:\n" + startupListener.getRecordedContentWhileWaitingAsString());
                }
                if (e instanceof CouldNotStartException) {
                    throw (CouldNotStartException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new CouldNotStartException("Could not successful start process. Output while waiting:\n" + startupListener.getRecordedContentWhileWaitingAsString(), e);
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownImmediatelyAfterStart(@Nonnull R requirement) {
        try {
            try {
                requirement.getStreamListener().notifyProcessTerminated(this._process, false);
            }
            finally {
                requirement.getStartupListener().notifyProcessTerminated(this._process, false);
            }
        }
        finally {
            ResourceUtils.closeQuietly((AutoCloseable)this);
        }
    }

    @Nonnull
    protected abstract P generateProcess(@Nonnull DEB var1, @Nonnull R var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            try {
                this._process.close();
                this._process.waitFor();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.warn("Could not stop the process. The process will still be on this computer. You have to stop it manually.", (Throwable)e);
            }
            finally {
                ThreadUtils.stop(this._monitors);
            }
        }
        finally {
            try {
                ResourceUtils.closeQuietlyIfAutoCloseable(this._requirement.getStartupListener());
            }
            finally {
                ResourceUtils.closeQuietlyIfAutoCloseable(this._requirement.getStreamListener());
            }
        }
    }

    @Nonnull
    public ByteCount getSizeOfReadBuffer() {
        return DEFAULT_SIZE_OF_READ_BUFFER;
    }

    @Nonnull
    public R getRequirement() {
        return this._requirement;
    }

    @Nonnull
    public P getProcess() {
        return this._process;
    }

    public String toString() {
        P process = this.getProcess();
        Object pid = process.getId();
        return this.getClass().getSimpleName() + "{" + (pid != null ? "pid=" + pid + ", " : "") + "alive=" + process.isAlive() + "}";
    }
}

