/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.daemon.BaseProcessDaemonQuery;
import org.echocat.jomon.process.daemon.ProcessDaemon;
import org.echocat.jomon.process.daemon.ProcessDaemonRequirement;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.jomon.runtime.repository.InsertingRepository;
import org.echocat.jomon.runtime.repository.QueryableRepository;
import org.echocat.jomon.runtime.repository.RemovingRepository;
import org.echocat.jomon.runtime.util.ResourceUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ThreadSafe
public class ProcessDaemonRepository<E, ID, P extends GeneratedProcess<E, ID>, D extends ProcessDaemon<E, ID, P, ?, ?>, R extends ProcessDaemonRequirement<E, ID, P, ? extends D>, Q extends BaseProcessDaemonQuery<E, ID, ?, ? extends D>, G extends Generator<P, ?>>
implements QueryableRepository<Q, ID, D>,
Iterable<D>,
RemovingRepository<Q, ID>,
InsertingRepository<D>,
Generator<D, R>,
AutoCloseable {
    @Nonnull
    private static final Comparator<Constructor<?>> BY_PARAMETER_COUNT = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            return Integer.compare(o2.getParameterTypes().length, o1.getParameterTypes().length);
        }
    };
    @Nonnull
    private final Thread _shutdownHook = new Thread("ShutdownProcessDaemons"){

        @Override
        public void run() {
            ProcessDaemonRepository.this.close();
        }
    };
    @Nonnull
    private final Map<ID, D> _idToProcess = new ConcurrentHashMap<ID, D>();
    @Nonnull
    private final G _processGenerator;

    public ProcessDaemonRepository(@Nonnull G processGenerator) {
        this._processGenerator = processGenerator;
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
    }

    @Nonnull
    public D generate(@Nonnull R requirement) {
        D daemon = this.createInstanceFor(requirement);
        this._idToProcess.put(((ProcessDaemon)daemon).getProcess().getId(), daemon);
        return daemon;
    }

    public void insert(@Nonnull D daemon) {
        this._idToProcess.put(((ProcessDaemon)daemon).getProcess().getId(), daemon);
    }

    @Nullable
    public D findOneBy(@Nonnull ID id) {
        return (D)((ProcessDaemon)this._idToProcess.get(id));
    }

    @Nullable
    public D findOneBy(@Nonnull Q query) {
        return (D)((ProcessDaemon)CollectionUtils.findFirstOf(this.findBy(query)));
    }

    @Nonnull
    public CloseableIterator<D> findBy(@Nonnull Q query) {
        return IteratorUtils.filter(this.iterator(), query);
    }

    public long countBy(@Nonnull Q query) {
        return CollectionUtils.countElementsOf(this.iterator(), query);
    }

    public boolean removeBy(@Nonnull ID id) {
        ProcessDaemon daemon = (ProcessDaemon)this._idToProcess.remove(id);
        if (daemon != null) {
            ResourceUtils.closeQuietly((AutoCloseable)daemon);
        }
        return daemon != null;
    }

    public long removeBy(@Nonnull Q query) {
        long removed = 0L;
        try (CloseableIterator<D> i = this.findBy(query);){
            while (i.hasNext()) {
                ProcessDaemon daemon = (ProcessDaemon)i.next();
                Object id = daemon.getProcess().getId();
                if (this._idToProcess.remove(id) == null) continue;
                ResourceUtils.closeQuietly((AutoCloseable)daemon);
                ++removed;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Collection<D> getCopySafe() {
        Map<ID, D> map = this._idToProcess;
        synchronized (map) {
            return new HashSet<D>(this._idToProcess.values());
        }
    }

    @Override
    public Iterator<D> iterator() {
        return this.getCopySafe().iterator();
    }

    @Nonnull
    protected Pair<Constructor<D>, Object[]> getConstructorFor(@Nonnull R requirement) {
        return this.getConstructorFor(requirement.getType(), requirement);
    }

    @Nonnull
    protected Pair<Constructor<D>, Object[]> getConstructorFor(@Nonnull Class<? extends D> type, @Nonnull R requirement) {
        List<Object> potentialParameters = this.getPotentialParametersFor(requirement);
        ImmutablePair result = null;
        for (Constructor<D> constructor : this.getPotentialConstructorsSortedFor(type)) {
            Object[] parameters = this.findRightParametersFor(constructor, potentialParameters);
            if (parameters == null) continue;
            result = new ImmutablePair(constructor, (Object)parameters);
        }
        if (result == null) {
            throw new IllegalArgumentException("Could not find a valid constructor for daemon " + type.getName() + ".");
        }
        return result;
    }

    @Nullable
    protected Object[] findRightParametersFor(@Nonnull Constructor<D> potentialConstructor, @Nonnull List<Object> potentialParameters) {
        Class<?>[] types = potentialConstructor.getParameterTypes();
        Object[] parameters = new Object[types.length];
        boolean allFound = true;
        for (int i = 0; i < types.length; ++i) {
            Class<?> expectedType = types[i];
            parameters[i] = this.findRightParameterFor(expectedType, potentialParameters);
            if (parameters[i] != null) continue;
            allFound = false;
            break;
        }
        return allFound ? parameters : null;
    }

    @Nullable
    protected Object findRightParameterFor(@Nonnull Class<?> expectedType, @Nonnull List<Object> potentialParameters) {
        Object result = null;
        for (Object potentialParameter : potentialParameters) {
            if (!expectedType.isInstance(potentialParameter)) continue;
            result = potentialParameter;
            break;
        }
        return result;
    }

    @Nonnull
    protected List<Constructor<D>> getPotentialConstructorsSortedFor(@Nonnull Class<? extends D> type) {
        List potentialConstructors = CollectionUtils.asList((Object[])type.getConstructors());
        Collections.sort(potentialConstructors, BY_PARAMETER_COUNT);
        return potentialConstructors;
    }

    @Nonnull
    protected List<Object> getPotentialParametersFor(@Nonnull R requiremnt) {
        return CollectionUtils.asImmutableList((Object[])new Object[]{requiremnt, this._processGenerator, this});
    }

    @Nonnull
    protected D createInstanceFor(@Nonnull R requirement) {
        return this.createInstanceFor(this.getConstructorFor(requirement), requirement);
    }

    @Nonnull
    protected D createInstanceFor(@Nonnull Pair<Constructor<D>, Object[]> constructorAndParameters, @Nonnull R requirement) {
        ProcessDaemon result;
        try {
            result = (ProcessDaemon)((Constructor)constructorAndParameters.getLeft()).newInstance((Object[])constructorAndParameters.getRight());
        }
        catch (Exception e) {
            Throwable cause;
            Throwable target = e instanceof InvocationTargetException ? ((cause = e.getCause()) != null ? cause : e) : e;
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new CouldNotStartException("Could not start daemon " + requirement.getType().getName() + ".", e);
        }
        return (D)result;
    }

    @Nonnull
    protected Iterator<Class<?>> getTypesIteratorFor(@Nonnull R requirement) {
        return CollectionUtils.asSingletonIterator(requirement.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Map<ID, D> map = this._idToProcess;
            synchronized (map) {
                Iterator<D> i = this._idToProcess.values().iterator();
                while (i.hasNext()) {
                    ProcessDaemon daemon = (ProcessDaemon)i.next();
                    ResourceUtils.closeQuietly((AutoCloseable)daemon);
                    i.remove();
                }
            }
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }
}

