/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListenerProvider;
import org.echocat.jomon.runtime.CollectionUtils;

public class CompoundStreamListenerProvider
implements StreamListenerProvider {
    @Nullable
    private final StreamListener<?> _fallback;
    @Nonnull
    private final Iterable<StreamListenerProvider> _delegates;

    public CompoundStreamListenerProvider(boolean respectSystemProviders, StreamListenerProvider ... delegates) {
        this(null, respectSystemProviders, delegates);
    }

    public CompoundStreamListenerProvider(boolean respectSystemProviders, @Nullable Iterable<StreamListenerProvider> delegates) {
        this(null, respectSystemProviders, delegates);
    }

    public CompoundStreamListenerProvider(@Nullable StreamListener<?> fallback, boolean respectSystemProviders, StreamListenerProvider ... delegates) {
        this(fallback, respectSystemProviders, CollectionUtils.asImmutableList((Object[])delegates));
    }

    public CompoundStreamListenerProvider(@Nullable StreamListener<?> fallback, boolean respectSystemProviders, @Nullable Iterable<StreamListenerProvider> delegates) {
        this._fallback = fallback;
        this._delegates = respectSystemProviders ? Iterables.concat(delegates, this.createSystemProviders()) : delegates;
    }

    @Nonnull
    protected Iterable<? extends StreamListenerProvider> createSystemProviders() {
        return CollectionUtils.asImmutableList(ServiceLoader.load(StreamListenerProvider.class));
    }

    @Override
    @Nullable
    public <P extends GeneratedProcess<?, ?>> StreamListener<P> provideFor(@Nonnull Class<P> referenceType, @Nonnull String configuration) {
        StreamListenerProvider delegate;
        StreamListener<Object> result = null;
        Iterator<StreamListenerProvider> i$ = this._delegates.iterator();
        while (i$.hasNext() && (result = (delegate = i$.next()).provideFor(referenceType, configuration)) == null) {
        }
        if (result == null && this._fallback != null && this._fallback.canHandleReferenceType(referenceType)) {
            result = this._fallback;
        }
        return result;
    }
}

