/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.format.DefaultMessageFormatter;
import org.echocat.jomon.runtime.format.MessageFormatter;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.ByteCount;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;

@ThreadSafe
public abstract class LineBasedStreamListenerSupport<P extends GeneratedProcess<?, ?>, T extends LineBasedStreamListenerSupport<P, T>>
implements StreamListener<P>,
Closeable {
    public static final String[] KEYS = new String[]{"timeStamp", "streamType", "message", "process"};
    private final Map<BufferKey<P>, ByteBuffer> _outputBuffers = new HashMap<BufferKey<P>, ByteBuffer>();
    private final Lock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    @Nonnull
    private MessageFormatter _formatter = DefaultMessageFormatter.messageFormatterFor((String)"[{timeStamp,date,yyyy-MM-dd HH:mm:ss} {streamType}] {message}\n", (String[])KEYS);
    private volatile boolean _closed;
    @Nonnull
    private Duration _maximumAllowedTimeWithoutFlush = Duration.duration((String)"10s");
    @Nonnull
    private ByteCount _bufferSize = ByteCount.byteCount((String)"1k");
    @Nonnegative
    private int _maximumNumberOfBuffers = StreamType.values().length;
    @Nonnull
    private Charset _charset = Charset.defaultCharset();

    @Override
    public boolean canHandleReferenceType(@Nonnull Class<?> type) {
        return true;
    }

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull MessageFormatter formatter) {
        this._formatter = formatter;
        return this.thisObject();
    }

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull String pattern, @Nonnull Locale locale) {
        return this.whichFormatsMessagesWith((MessageFormatter)DefaultMessageFormatter.messageFormatterFor((String)pattern, (Locale)locale, (String[])KEYS));
    }

    @Nonnull
    public T whichFormatsMessagesWith(@Nonnull String pattern) {
        return this.whichFormatsMessagesWith((MessageFormatter)DefaultMessageFormatter.messageFormatterFor((String)pattern, (String[])KEYS));
    }

    @Nonnull
    public T withMaximumNumberOfBuffers(@Nonnegative int value) {
        this._maximumNumberOfBuffers = value;
        return this.thisObject();
    }

    @Nonnull
    public T withMaximumAllowedTimeWithoutFlush(@Nonnull Duration duration) {
        this._maximumAllowedTimeWithoutFlush = duration;
        return this.thisObject();
    }

    @Nonnull
    public T withMaximumAllowedTimeWithoutFlush(@Nonnull String duration) {
        return this.withMaximumAllowedTimeWithoutFlush(Duration.duration((String)duration));
    }

    @Nonnull
    public T withBufferSize(@Nonnull String byteCount) {
        return this.withBufferSize(ByteCount.byteCount((String)byteCount));
    }

    @Nonnull
    public T withBufferSize(@Nonnull ByteCount byteCount) {
        this._bufferSize = byteCount;
        return this.thisObject();
    }

    @Nonnull
    public T withCharset(@Nonnull Charset charset) {
        this._charset = charset;
        return this.thisObject();
    }

    @Nonnull
    public T withCharset(@Nonnull String charset) {
        return this.withCharset(Charset.forName(charset));
    }

    @Override
    public void notifyProcessStarted(@Nonnull P process) {
    }

    @Override
    public void notifyProcessStartupDone(@Nonnull P process) {
    }

    @Override
    public void notifyProcessTerminated(@Nonnull P process, boolean regular) {
    }

    @Override
    public void notifyOutput(@Nonnull P process, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull StreamType streamType) {
        this.formatAndWrite(process, data, offset, length, streamType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushOutput(@Nonnull P process, @Nonnull StreamType streamType) {
        BufferKey<P> key = new BufferKey<P>(process, streamType);
        ByteBuffer buffer = this.getBufferFor(key);
        BufferKey<P> bufferKey = key;
        synchronized (bufferKey) {
            this.flush(key, buffer);
        }
    }

    protected void formatAndWrite(@Nonnull P process, @Nonnull String line, @Nonnull StreamType streamType) {
        if (this._closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.write(process, this.format(process, line, streamType), streamType);
    }

    protected void formatAndWrite(@Nonnull P process, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull StreamType streamType) {
        final BufferKey<P> key = new BufferKey<P>(process, streamType);
        final ByteBuffer buffer = this.getBufferFor(key);
        this.each(data, offset, length, new Consumer<ByteBuffer, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(@Nullable ByteBuffer value) {
                BufferKey bufferKey = key;
                synchronized (bufferKey) {
                    buffer.put(value);
                    if (LineBasedStreamListenerSupport.this.endsWithNewLine(buffer)) {
                        LineBasedStreamListenerSupport.this.flush(key, buffer);
                    }
                }
            }
        });
    }

    protected void flush(@Nonnull BufferKey<P> key, @Nonnull ByteBuffer buffer) {
        buffer.flip();
        CharBuffer decoded = this._charset.decode(buffer);
        this.formatAndWrite(key.getProcess(), decoded.toString(), key.getStreamType());
        buffer.clear();
        key.notifyFlushed();
    }

    protected boolean endsWithNewLine(@Nonnull ByteBuffer buffer) {
        return buffer.position() > 0 && buffer.get(buffer.position() - 1) == 10;
    }

    @Nonnull
    protected void each(@Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull Consumer<ByteBuffer, RuntimeException> consumer) {
        int currentStart = offset;
        for (int i = offset; i < length; ++i) {
            if (data[i] != 10) continue;
            consumer.consume((Object)ByteBuffer.wrap(data, currentStart, i + 1 - currentStart));
            currentStart = i + 1;
        }
        if (length > currentStart) {
            consumer.consume((Object)ByteBuffer.wrap(data, currentStart, length - currentStart));
        }
    }

    protected abstract void write(@Nonnull P var1, @Nonnull String var2, @Nonnull StreamType var3);

    @Nonnull
    protected String format(@Nonnull P process, @Nonnull String line, @Nonnull StreamType streamType) {
        return this._formatter.format(CollectionUtils.asMap((Object[])new Object[]{"process", process, "timeStamp", new Date(), "streamType", streamType, "message", this.removeLastLineBreakFrom(line)}));
    }

    @Nonnull
    protected String removeLastLineBreakFrom(@Nonnull String step0) {
        String step1 = step0.endsWith("\n") ? step0.substring(0, step0.length() - 1) : step0;
        String step2 = step1.endsWith("\r") ? step1.substring(0, step1.length() - 1) : step1;
        String step3 = step2.endsWith("\n") ? step2.substring(0, step1.length() - 2) : step2;
        return step3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean force) {
        Duration maximumAllowedTimeWithoutFlush = this._maximumAllowedTimeWithoutFlush;
        Map<BufferKey<P>, ByteBuffer> map = this._outputBuffers;
        synchronized (map) {
            for (Map.Entry<BufferKey<P>, ByteBuffer> keyAndBuffer : this._outputBuffers.entrySet()) {
                BufferKey<P> key = keyAndBuffer.getKey();
                ByteBuffer buffer = keyAndBuffer.getValue();
                BufferKey<P> bufferKey = key;
                synchronized (bufferKey) {
                    if (force || key.isFlushNeeded(maximumAllowedTimeWithoutFlush)) {
                        this.flush(key, buffer);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this._closed = true;
        this._lock.lock();
        try {
            this.flush(true);
            this._outputBuffers.clear();
        }
        finally {
            this._lock.unlock();
        }
    }

    @Nonnull
    public MessageFormatter getFormatter() {
        return this._formatter;
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Nonnull
    public Duration getMaximumAllowedTimeWithoutFlush() {
        return this._maximumAllowedTimeWithoutFlush;
    }

    @Nonnull
    public ByteCount getBufferSize() {
        return this._bufferSize;
    }

    @Nonnegative
    public int getMaximumNumberOfBuffers() {
        return this._maximumNumberOfBuffers;
    }

    @Nonnull
    public Charset getCharset() {
        return this._charset;
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ByteBuffer getBufferFor(@Nonnull BufferKey<P> key) {
        Map<BufferKey<P>, ByteBuffer> map = this._outputBuffers;
        synchronized (map) {
            ByteBuffer buffer = this._outputBuffers.get(key);
            if (buffer == null) {
                buffer = this._bufferSize.allocateBuffer();
                if (this._outputBuffers.size() >= this._maximumNumberOfBuffers && !this._outputBuffers.isEmpty()) {
                    BufferKey<P> firstKey = this._outputBuffers.keySet().iterator().next();
                    ByteBuffer old = this._outputBuffers.remove(firstKey);
                    this.flush(key, old);
                }
                if (this._maximumNumberOfBuffers >= 1) {
                    this._outputBuffers.put(key, buffer);
                }
            }
            return buffer;
        }
    }

    @Nonnull
    protected Lock lock() {
        return this._lock;
    }

    @Nonnull
    protected Condition condition() {
        return this._condition;
    }

    protected static class BufferKey<P extends GeneratedProcess<?, ?>> {
        @Nonnull
        private final P _process;
        @Nonnull
        private final StreamType _streamType;
        @Nonnegative
        private long _lastFlushAtInMillis;

        public BufferKey(@Nonnull P process, @Nonnull StreamType streamType) {
            this._process = process;
            this._streamType = streamType;
            this.notifyFlushed();
        }

        @Nonnull
        public P getProcess() {
            return this._process;
        }

        @Nonnull
        public StreamType getStreamType() {
            return this._streamType;
        }

        @Nonnegative
        public long getLastFlushAtInMillis() {
            return this._lastFlushAtInMillis;
        }

        public boolean isFlushNeeded(@Nonnull Duration maximumAllowedTimeWithoutFlush) {
            long flushRequiredAt = this._lastFlushAtInMillis + maximumAllowedTimeWithoutFlush.toMilliSeconds();
            return flushRequiredAt <= System.currentTimeMillis();
        }

        public void notifyFlushed() {
            this._lastFlushAtInMillis = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                BufferKey that = (BufferKey)o;
                result = this._process.equals(that._process) && this._streamType == that._streamType;
            }
            return result;
        }

        public int hashCode() {
            int result = this._process.hashCode();
            result = 31 * result + this._streamType.hashCode();
            return result;
        }
    }
}

