/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.local.daemon;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.daemon.ProcessDaemon;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalGeneratedProcessRequirement;
import org.echocat.jomon.process.local.LocalProcessRepository;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRequirement;
import org.echocat.jomon.runtime.generation.Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalProcessDaemon<R extends LocalProcessDaemonRequirement<?>>
extends ProcessDaemon<File, Long, LocalGeneratedProcess, R, Generator<LocalGeneratedProcess, LocalGeneratedProcessRequirement>> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProcessDaemon.class);
    @Nullable
    private File _temporaryDirectory;

    protected LocalProcessDaemon(@Nonnull R requirement) throws CouldNotStartException {
        this(LocalProcessRepository.getInstance(), requirement);
    }

    protected LocalProcessDaemon(@Nonnull LocalProcessRepository processRepository, @Nonnull R requirement) throws CouldNotStartException {
        super(processRepository, requirement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            try {
                if (this._temporaryDirectory != null) {
                    FileUtils.deleteDirectory((File)this._temporaryDirectory);
                }
            }
            catch (Exception e) {
                LOG.warn("Could not delete the temporary directory '" + this._temporaryDirectory + "' with the data values of the process. The files will remain on the disk and still will use disk space. You have to delete it manually.", (Throwable)e);
            }
            finally {
                this._temporaryDirectory = null;
            }
        }
    }

    @Nonnull
    protected File getBaseDirectoryOfEnvironmentVariable(@Nonnull String name) throws IOException {
        String directoryPath = System.getenv(name);
        if (directoryPath == null) {
            throw new IllegalStateException("In the current environment is no " + name + " environment variable set.");
        }
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it does not exists.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it is not a directory.");
        }
        return directory.getCanonicalFile();
    }

    @Nonnull
    protected File getDirectoryOfEnvironmentVariable(@Nonnull String name, @Nonnull SubPath subPath) throws IOException {
        File directory;
        File baseDirectory = this.getBaseDirectoryOfEnvironmentVariable(name);
        if (subPath == SubPath.inBaseDirectory) {
            directory = baseDirectory;
        } else {
            directory = new File(baseDirectory, subPath.getValue());
            if (!directory.exists()) {
                throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it does not exists.");
            }
            if (!directory.isDirectory()) {
                throw new IllegalStateException("In the current environment points the " + name + " environment variable to " + directory + " but it is not a directory.");
            }
        }
        return directory.getCanonicalFile();
    }

    @Nonnull
    protected File getBinaryOfEnvironmentVariable(@Nonnull String environmentVariableName, @Nonnull SubPath subPath, @Nonnull String binaryFileName) throws IOException {
        File directory = this.getDirectoryOfEnvironmentVariable(environmentVariableName, subPath);
        File binary = new File(directory, binaryFileName);
        if (!binary.canExecute() && !(binary = new File(directory, binaryFileName + ".exe")).canExecute()) {
            throw new IllegalStateException("In the current environment points the " + environmentVariableName + " environment variable to " + directory + " with no " + binaryFileName + " executable in it.");
        }
        return binary;
    }

    @Nonnull
    protected File createTemporaryDirectory(@Nonnull String prefix, @Nonnull String suffix) throws IOException {
        if (this._temporaryDirectory != null) {
            throw new IllegalStateException("There was already a temporary directory created for this process");
        }
        File result = File.createTempFile(prefix, suffix);
        result.delete();
        if (!result.mkdir()) {
            throw new IOException("Could not create temporary directory: " + result);
        }
        result.deleteOnExit();
        this._temporaryDirectory = result;
        return result;
    }

    public static enum SubPath {
        inBaseDirectory(null),
        inBinDirectory("bin");

        private final String _value;

        private SubPath(String value) {
            this._value = value;
        }

        @Nullable
        public String getValue() {
            return this._value;
        }
    }
}

